/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.content.ContentDaoDataProvider;
import org.broadleafcommerce.core.content.dao.ContentDao;
import org.broadleafcommerce.core.content.dao.ContentDetailsDao;
import org.broadleafcommerce.core.content.domain.Content;
import org.broadleafcommerce.core.content.domain.ContentDetails;
import org.broadleafcommerce.core.content.service.ContentService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class ContentServiceTest
extends BaseTest {
    @Resource
    private ContentService contentService;
    @Resource
    private ContentDao contentDao;
    @Resource
    private ContentDetailsDao contentDetailsDao;
    private Integer contentId;
    private Integer checkedOutContentId;
    private String readyForApprovalSandbox;

    @Test(groups={"testContentService"})
    public void testCanary() {
        assert (this.contentService != null);
    }

    @Test(groups={"testSaveContent"}, dataProvider="basicContentAndDetail", dataProviderClass=ContentDaoDataProvider.class)
    @Transactional
    @Rollback(value=false)
    public void testSaveContent(Content content, ContentDetails contentDetails) {
        Content contentCreated = this.contentDao.saveContent(content);
        assert (contentCreated.getId() != null);
        contentDetails.setId(contentCreated.getId());
        ContentDetails contentDetailsCreated = this.contentDetailsDao.save(contentDetails);
        Content contentFromDB = this.contentDao.readContentById(contentCreated.getId());
        ContentDetails contentDetailsFromDB = this.contentDetailsDao.readContentDetailsById(contentCreated.getId());
        assert (contentFromDB != null);
        assert (contentDetailsFromDB != null);
        this.contentId = contentCreated.getId();
    }

    @Test(groups={"testCheckoutContentToSandbox"}, dependsOnGroups={"testSaveContent"})
    @Transactional
    @Rollback(value=false)
    public void testCheckoutContentToSandbox() {
        ArrayList<Integer> contentIds = new ArrayList<Integer>();
        contentIds.add(this.contentId);
        List newContent = this.contentService.checkoutContentToSandbox(contentIds, "UserSandBox");
        assert (newContent != null && !newContent.isEmpty());
        assert (((Content)newContent.get(0)).getId() != null);
        this.checkedOutContentId = ((Content)newContent.get(0)).getId();
    }

    @Test(groups={"testSubmitContent"}, dependsOnGroups={"testCheckoutContentToSandbox"})
    @Transactional
    @Rollback(value=false)
    public void testSubmitContent() {
        assert (this.checkedOutContentId != null);
        assert (this.checkedOutContentId != this.contentId);
        ArrayList<Integer> contentIds = new ArrayList<Integer>();
        contentIds.add(this.checkedOutContentId);
        this.contentService.submitContentFromSandbox(contentIds, "UserSandBox", "NumeroUno", "NoteTest");
        List awaitingApproval = this.contentDao.readContentAwaitingApproval();
        assert (awaitingApproval != null && !awaitingApproval.isEmpty());
        this.readyForApprovalSandbox = ((Content)awaitingApproval.get(0)).getSandbox();
    }

    @Test(groups={"testApproveContent"}, dependsOnGroups={"testSubmitContent"})
    @Transactional
    public void testApproveContent() {
        List awaitingApproval = this.contentDao.readContentAwaitingApproval();
        assert (awaitingApproval != null && !awaitingApproval.isEmpty());
        ArrayList<Integer> contentIds = new ArrayList<Integer>();
        contentIds.add(this.checkedOutContentId);
        this.contentService.approveContent(contentIds, this.readyForApprovalSandbox, "NumeroUno");
        awaitingApproval = this.contentDao.readContentAwaitingApproval();
        assert (awaitingApproval == null || awaitingApproval.isEmpty());
    }
}

