/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.vendor;

import java.util.Currency;
import java.util.Locale;
import javax.annotation.Resource;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.vendor.service.cache.ServiceResponseCacheable;
import org.broadleafcommerce.test.BaseTest;
import org.broadleafcommerce.vendor.cybersource.service.CyberSourceServiceManager;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceBillingRequest;
import org.broadleafcommerce.vendor.cybersource.service.message.CyberSourceRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.CyberSourceTaxService;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxItemRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxRequest;
import org.broadleafcommerce.vendor.cybersource.service.tax.message.CyberSourceTaxResponse;
import org.springframework.test.annotation.Rollback;
import org.testng.annotations.Test;

public class CyberSourceTaxServiceTest
extends BaseTest {
    @Resource
    private CyberSourceServiceManager serviceManager;

    @Test(groups={"testSuccessfulCyberSourceTax"})
    @Rollback(value=false)
    public void testSuccessfulCyberSourceTax() throws Exception {
        if (this.serviceManager.getMerchantId().equals("?")) {
            return;
        }
        CyberSourceTaxRequest taxRequest = new CyberSourceTaxRequest();
        taxRequest.setCurrency(Currency.getInstance(Locale.US).getCurrencyCode());
        taxRequest.setNexus("CA");
        taxRequest.setOrderAcceptancePostalCode("94043");
        CyberSourceBillingRequest billingRequest = new CyberSourceBillingRequest();
        billingRequest.setCity("Mountain View");
        billingRequest.setPostalCode("94043");
        billingRequest.setState("CA");
        billingRequest.setStreet1("1295 Charleston Road");
        billingRequest.setCountry("US");
        taxRequest.setBillingRequest(billingRequest);
        CyberSourceTaxItemRequest itemRequest1 = new CyberSourceTaxItemRequest();
        itemRequest1.setDescription("First Item");
        itemRequest1.setQuantity(Long.valueOf(2L));
        itemRequest1.setShortDescription("firstItem");
        itemRequest1.setUnitPrice(new Money(12.34));
        taxRequest.getItemRequests().add(itemRequest1);
        CyberSourceTaxService service = (CyberSourceTaxService)this.serviceManager.getValidService((CyberSourceRequest)taxRequest);
        ((ServiceResponseCacheable)service).clearCache();
        CyberSourceTaxResponse response = service.process(taxRequest);
        assert (response.getReasonCode() == 100);
        assert (!response.getRequestToken().equals("from-cache"));
        Money totalTaxAmount = response.getItemResponses()[0].getTotalTaxAmount();
        assert (totalTaxAmount != null && totalTaxAmount.greaterThan(new Money(0.0)));
        CyberSourceTaxResponse response2 = service.process(taxRequest);
        assert (response2.getReasonCode() == 100);
        assert (response2.getRequestToken().equals("from-cache"));
        Money totalTaxAmount2 = response2.getItemResponses()[0].getTotalTaxAmount();
        assert (totalTaxAmount2 != null && totalTaxAmount2.greaterThan(new Money(0.0)));
        assert (totalTaxAmount.equals((Object)totalTaxAmount2));
    }
}

