/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.cache.engine;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.cache.engine.HydratedAnnotationManager;
import org.broadleafcommerce.common.cache.engine.HydratedCacheManager;
import org.broadleafcommerce.common.cache.engine.HydrationDescriptor;
import org.broadleafcommerce.common.cache.engine.HydrationScanner;

public abstract class AbstractHydratedCacheManager
implements CacheEventListener,
HydratedCacheManager,
HydratedAnnotationManager {
    private static final Log LOG = LogFactory.getLog(AbstractHydratedCacheManager.class);
    private Map<String, HydrationDescriptor> hydrationDescriptors = Collections.synchronizedMap(new HashMap(100));

    @Override
    public HydrationDescriptor getHydrationDescriptor(Object entity) {
        if (this.hydrationDescriptors.containsKey(entity.getClass().getName())) {
            return this.hydrationDescriptors.get(entity.getClass().getName());
        }
        HydrationDescriptor descriptor = new HydrationDescriptor();
        Class<?> topEntityClass = this.getTopEntityClass(entity);
        HydrationScanner scanner = new HydrationScanner(topEntityClass, entity.getClass());
        scanner.init();
        descriptor.setHydratedMutators(scanner.getCacheMutators());
        Map<String, Method[]> mutators = scanner.getIdMutators();
        if (mutators.size() != 1) {
            throw new RuntimeException("Broadleaf Commerce Hydrated Cache currently only supports entities with a single @Id annotation.");
        }
        Method[] singleMutators = mutators.values().iterator().next();
        descriptor.setIdMutators(singleMutators);
        String cacheRegion = scanner.getCacheRegion();
        if (cacheRegion == null || "".equals(cacheRegion)) {
            cacheRegion = topEntityClass.getName();
        }
        descriptor.setCacheRegion(cacheRegion);
        this.hydrationDescriptors.put(entity.getClass().getName(), descriptor);
        return descriptor;
    }

    protected Class<?> getTopEntityClass(Object entity) {
        Class<?> myClass = entity.getClass();
        for (Class<?> superClass = entity.getClass().getSuperclass(); superClass != null && superClass.getName().startsWith("org.broadleaf"); superClass = superClass.getSuperclass()) {
            myClass = superClass;
        }
        return myClass;
    }

    public void dispose() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Disposing of all hydrated cache members");
        }
        this.hydrationDescriptors.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }
}

