/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.email.service.message;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class EmailPropertyType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, EmailPropertyType> TYPES = new HashMap<String, EmailPropertyType>();
    public static final EmailPropertyType USER = new EmailPropertyType("user", "User");
    public static final EmailPropertyType INFO = new EmailPropertyType("info", "Info");
    public static final EmailPropertyType SERVERINFO = new EmailPropertyType("serverInfo", "Server Info");
    private String type;
    private String friendlyType;

    public static EmailPropertyType getInstance(String type) {
        return TYPES.get(type);
    }

    public EmailPropertyType() {
    }

    public EmailPropertyType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailPropertyType other = (EmailPropertyType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

