/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context.merge.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extensibility.context.merge.handlers.BaseHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeReplaceInsert
extends BaseHandler {
    private static final Log LOG = LogFactory.getLog(NodeReplaceInsert.class);
    private static final Comparator<Node> NODE_COMPARATOR = new Comparator<Node>(){

        @Override
        public int compare(Node arg0, Node arg1) {
            int response = -1;
            if (arg0.isSameNode(arg1)) {
                response = 0;
            }
            if (response != 0) {
                boolean eof = false;
                Node parentNode = arg0;
                while (!eof) {
                    if ((parentNode = parentNode.getParentNode()) == null) {
                        eof = true;
                        continue;
                    }
                    if (!arg1.isSameNode(parentNode)) continue;
                    response = 0;
                    eof = true;
                }
            }
            return response;
        }
    };

    @Override
    public Node[] merge(NodeList nodeList1, NodeList nodeList2, List<Node> exhaustedNodes) {
        if (nodeList1 == null || nodeList2 == null || nodeList1.getLength() == 0 || nodeList2.getLength() == 0) {
            return null;
        }
        Node[] primaryNodes = new Node[nodeList1.getLength()];
        for (int j = 0; j < primaryNodes.length; ++j) {
            primaryNodes[j] = nodeList1.item(j);
        }
        ArrayList<Node> list = new ArrayList<Node>();
        for (int j = 0; j < nodeList2.getLength(); ++j) {
            list.add(nodeList2.item(j));
        }
        List<Node> usedNodes = this.matchNodes(exhaustedNodes, primaryNodes, list);
        Node[] response = new Node[]{};
        response = usedNodes.toArray(response);
        return response;
    }

    private boolean exhaustedNodesContains(List<Node> exhaustedNodes, Node node) {
        boolean contains = false;
        for (Node exhaustedNode : exhaustedNodes) {
            if (NODE_COMPARATOR.compare(exhaustedNode, node) != 0) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private List<Node> matchNodes(List<Node> exhaustedNodes, Node[] primaryNodes, ArrayList<Node> list) {
        ArrayList<Node> usedNodes = new ArrayList<Node>(20);
        Iterator<Node> itr = list.iterator();
        Node parentNode = primaryNodes[0].getParentNode();
        Document ownerDocument = parentNode.getOwnerDocument();
        while (itr.hasNext()) {
            Node node = itr.next();
            if (!Element.class.isAssignableFrom(node.getClass()) || this.exhaustedNodesContains(exhaustedNodes, node)) continue;
            if (LOG.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer();
                sb.append("matching node for replacement: ");
                sb.append(node.getNodeName());
                int attrLength = node.getAttributes().getLength();
                for (int j = 0; j < attrLength; ++j) {
                    sb.append(" : (");
                    sb.append(node.getAttributes().item(j).getNodeName());
                    sb.append("/");
                    sb.append(node.getAttributes().item(j).getNodeValue());
                    sb.append(")");
                }
                LOG.debug((Object)sb.toString());
            }
            if (this.checkNode(usedNodes, primaryNodes, node)) continue;
            Node newNode = ownerDocument.importNode(node.cloneNode(true), true);
            parentNode.appendChild(newNode);
            usedNodes.add(node);
        }
        return usedNodes;
    }

    protected boolean checkNode(List<Node> usedNodes, Node[] primaryNodes, Node node) {
        if (this.replaceNode(primaryNodes, node, "id", usedNodes)) {
            return true;
        }
        if (this.replaceNode(primaryNodes, node, "name", usedNodes)) {
            return true;
        }
        return this.exactNodeExists(primaryNodes, node, usedNodes);
    }

    protected boolean exactNodeExists(Node[] primaryNodes, Node testNode, List<Node> usedNodes) {
        for (int j = 0; j < primaryNodes.length; ++j) {
            if (!primaryNodes[j].isEqualNode(testNode)) continue;
            usedNodes.add(primaryNodes[j]);
            return true;
        }
        return false;
    }

    protected boolean replaceNode(Node[] primaryNodes, Node testNode, final String attribute, List<Node> usedNodes) {
        if (testNode.getAttributes().getNamedItem(attribute) == null) {
            return false;
        }
        ArrayList<Node> filterList = new ArrayList<Node>();
        for (int j = 0; j < primaryNodes.length; ++j) {
            if (primaryNodes[j].getAttributes().getNamedItem(attribute) == null) continue;
            filterList.add(primaryNodes[j]);
        }
        Node[] filtered = new Node[]{};
        filtered = filterList.toArray(filtered);
        Comparator<Node> idCompare = new Comparator<Node>(){

            @Override
            public int compare(Node arg0, Node arg1) {
                Node id1 = arg0.getAttributes().getNamedItem(attribute);
                Node id2 = arg1.getAttributes().getNamedItem(attribute);
                String idVal1 = id1.getNodeValue();
                String idVal2 = id2.getNodeValue();
                return idVal1.compareTo(idVal2);
            }
        };
        Arrays.sort(filtered, idCompare);
        int pos = Arrays.binarySearch(filtered, testNode, idCompare);
        if (pos >= 0) {
            Node newNode = filtered[pos].getOwnerDocument().importNode(testNode.cloneNode(true), true);
            filtered[pos].getParentNode().replaceChild(newNode, filtered[pos]);
            usedNodes.add(testNode);
            return true;
        }
        return false;
    }
}

