/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.locale.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_LOCALE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
@AdminPresentationClass(friendlyName="baseLocale")
public class LocaleImpl
implements Locale {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="LOCALE_CODE")
    @AdminPresentation(friendlyName="Locale Code", order=1, group="Details", prominent=true)
    protected String localeCode;
    @Column(name="FRIENDLY_NAME")
    @AdminPresentation(friendlyName="Name", order=2, group="Details", prominent=true)
    protected String friendlyName;
    @Column(name="DEFAULT_FLAG")
    @AdminPresentation(friendlyName="Is Default", order=3, group="Details", prominent=true)
    protected Boolean defaultFlag;

    @Override
    public String getLocaleCode() {
        return this.localeCode;
    }

    @Override
    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    @Override
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Override
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Override
    public void setDefaultFlag(Boolean defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    @Override
    public Boolean getDefaultFlag() {
        return this.defaultFlag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Locale)) {
            return false;
        }
        LocaleImpl locale = (LocaleImpl)o;
        if (this.localeCode != null ? !this.localeCode.equals(locale.localeCode) : locale.localeCode != null) {
            return false;
        }
        return !(this.friendlyName != null ? !this.friendlyName.equals(locale.friendlyName) : locale.friendlyName != null);
    }

    public int hashCode() {
        int result = this.localeCode != null ? this.localeCode.hashCode() : 0;
        result = 31 * result + (this.friendlyName != null ? this.friendlyName.hashCode() : 0);
        return result;
    }
}

