/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class BroadleafAdminLogoutSuccessHandler
extends AbstractAuthenticationTargetUrlRequestHandler
implements LogoutSuccessHandler {
    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String targetUrl = this.determineTargetUrl(request, response);
        if (response.isCommitted()) {
            this.logger.debug((Object)("Response has already been committed. Unable to redirect to " + targetUrl));
            return;
        }
        String queryString = request.getQueryString();
        if (!StringUtils.isEmpty((String)queryString)) {
            targetUrl = targetUrl + "?" + queryString;
        }
        this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
    }
}

