/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.time;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class MonthType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, MonthType> TYPES = new HashMap<String, MonthType>();
    public static final MonthType JANUARY = new MonthType("1", "January");
    public static final MonthType FEBRUARY = new MonthType("2", "February");
    public static final MonthType MARCH = new MonthType("3", "March");
    public static final MonthType APRIL = new MonthType("4", "April");
    public static final MonthType MAY = new MonthType("5", "May");
    public static final MonthType JUNE = new MonthType("6", "June");
    public static final MonthType JULY = new MonthType("7", "July");
    public static final MonthType AUGUST = new MonthType("8", "August");
    public static final MonthType SEPTEMBER = new MonthType("9", "September");
    public static final MonthType OCTOBER = new MonthType("10", "October");
    public static final MonthType NOVEMBER = new MonthType("11", "November");
    public static final MonthType DECEMBER = new MonthType("12", "December");
    private String type;
    private String friendlyType;

    public static MonthType getInstance(String type) {
        return TYPES.get(type);
    }

    public MonthType() {
    }

    public MonthType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + MonthType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MonthType other = (MonthType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

