/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import org.broadleafcommerce.common.util.StatCalc;

public class StringUtil {
    public static long getChecksum(String test) {
        try {
            byte[] buffer = test.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            CheckedInputStream cis = new CheckedInputStream(bais, new Adler32());
            byte[] readBuffer = new byte[buffer.length];
            cis.read(readBuffer);
            return cis.getChecksum().getValue();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static double determineSimilarity(String test1, String test2) {
        String first = new String(test1);
        first = first.replaceAll("[ \\t\\n\\r\\f\\v\\/'-]", "");
        Long originalChecksum = StringUtil.getChecksum(first);
        String second = new String(test2);
        second = second.replaceAll("[ \\t\\n\\r\\f\\v\\/'-]", "");
        Long myChecksum = StringUtil.getChecksum(second);
        StatCalc calc = new StatCalc();
        calc.enter(originalChecksum.longValue());
        calc.enter(myChecksum.longValue());
        return calc.getStandardDeviation();
    }

    public static String cleanseUrlString(String input) {
        return StringUtil.removeSpecialCharacters(StringUtil.decodeUrl(input));
    }

    public static String decodeUrl(String encodedUrl) {
        try {
            return encodedUrl == null ? null : URLDecoder.decode(encodedUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return encodedUrl;
        }
    }

    public static String removeSpecialCharacters(String input) {
        if (input != null) {
            input = input.replaceAll("[ \\r\\n]", "");
        }
        return input;
    }
}

