/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.web.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.config.RuntimeEnvironmentPropertiesConfigurer;
import org.broadleafcommerce.common.web.util.PrecompressedHttpServletRequest;
import org.broadleafcommerce.common.web.util.PrecompressedHttpServletResponse;
import org.springframework.web.filter.GenericFilterBean;

public class PrecompressedArtifactFilter
extends GenericFilterBean {
    private boolean useWhileInDefaultEnvironment = true;
    @Resource(name="blConfiguration")
    RuntimeEnvironmentPropertiesConfigurer configurer;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        String gzipPath;
        String path;
        Object request = (HttpServletRequest)servletRequest;
        Object response = (HttpServletResponse)servletResponse;
        if ((!this.configurer.determineEnvironment().equals(this.configurer.getDefaultEnvironment()) || this.useWhileInDefaultEnvironment) && this.useGzipCompression((HttpServletRequest)request, (HttpServletResponse)response, path = this.getResourcePath((HttpServletRequest)request), gzipPath = path + ".gz")) {
            response.addHeader("Content-Encoding", "gzip");
            request = new PrecompressedHttpServletRequest((HttpServletRequest)request, path, gzipPath);
            response = new PrecompressedHttpServletResponse((HttpServletResponse)response, path);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public String getResourcePath(HttpServletRequest request) {
        String path = (String)request.getAttribute("javax.servlet.include.servlet_path");
        String info = (String)request.getAttribute("javax.servlet.include.path_info");
        if (path == null) {
            path = request.getServletPath();
            info = request.getPathInfo();
        }
        if (info != null) {
            path = path + info;
        }
        return path;
    }

    protected boolean useGzipCompression(HttpServletRequest request, HttpServletResponse response, String path, String gzipPath) throws MalformedURLException {
        if (gzipPath == null) {
            return false;
        }
        String temp = path.toLowerCase();
        if (temp.endsWith(".gif") || temp.endsWith(".png") || temp.endsWith(".jpg")) {
            return false;
        }
        if (this.getServletContext().getResource(gzipPath) == null) {
            return false;
        }
        if (response.containsHeader("Content-Encoding")) {
            return false;
        }
        String s = request.getParameter("gzip");
        if ("false".equals(s)) {
            return false;
        }
        Enumeration e = request.getHeaders("Accept-Encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("gzip") == -1) continue;
            return true;
        }
        return false;
    }

    public boolean isUseWhileInDefaultEnvironment() {
        return this.useWhileInDefaultEnvironment;
    }

    public void setUseWhileInDefaultEnvironment(boolean useWhileInDefaultEnvironment) {
        this.useWhileInDefaultEnvironment = useWhileInDefaultEnvironment;
    }

    public RuntimeEnvironmentPropertiesConfigurer getConfigurer() {
        return this.configurer;
    }

    public void setConfigurer(RuntimeEnvironmentPropertiesConfigurer configurer) {
        this.configurer = configurer;
    }
}

