/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.web.util;

import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.ExtensionMimeDetector;
import eu.medsea.mimeutil.detector.MagicMimeMimeDetector;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PrecompressedHttpServletResponse
extends HttpServletResponseWrapper {
    private final String originalPath;
    private final String contentType;

    public PrecompressedHttpServletResponse(HttpServletResponse response, String originalPath) {
        super(response);
        this.originalPath = originalPath;
        Collection mimeTypes = MimeUtil.getMimeTypes((String)originalPath);
        if (!mimeTypes.isEmpty()) {
            MimeType mimeType = (MimeType)mimeTypes.iterator().next();
            this.contentType = mimeType.toString();
        } else {
            this.contentType = null;
        }
    }

    public String getContentType() {
        String contentType = super.getContentType();
        if (contentType.contains("zip") && this.contentType != null) {
            return this.contentType;
        }
        return contentType;
    }

    public void setContentType(String type) {
        if (type.contains("zip") && this.contentType != null) {
            super.setContentType(this.contentType);
        } else {
            super.setContentType(type);
        }
    }

    static {
        MimeUtil.registerMimeDetector((String)ExtensionMimeDetector.class.getName());
        MimeUtil.registerMimeDetector((String)MagicMimeMimeDetector.class.getName());
    }
}

