/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.dao.PaymentInfoDao;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.springframework.stereotype.Repository;

@Repository(value="blPaymentInfoDao")
public class PaymentInfoDaoImpl
implements PaymentInfoDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public PaymentInfo save(PaymentInfo paymentInfo) {
        return (PaymentInfo)this.em.merge((Object)paymentInfo);
    }

    @Override
    public PaymentResponseItem save(PaymentResponseItem paymentResponseItem) {
        return (PaymentResponseItem)this.em.merge((Object)paymentResponseItem);
    }

    @Override
    public PaymentLog save(PaymentLog log) {
        return (PaymentLog)this.em.merge((Object)log);
    }

    @Override
    public PaymentInfo readPaymentInfoById(Long paymentId) {
        return (PaymentInfo)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.payment.domain.PaymentInfo"), (Object)paymentId);
    }

    @Override
    public List<PaymentInfo> readPaymentInfosForOrder(Order order) {
        Query query = this.em.createNamedQuery("BC_READ_ORDERS_PAYMENTS_BY_ORDER_ID");
        query.setParameter("orderId", (Object)order.getId());
        return query.getResultList();
    }

    @Override
    public PaymentInfo create() {
        return (PaymentInfo)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.PaymentInfo");
    }

    @Override
    public PaymentResponseItem createResponseItem() {
        return (PaymentResponseItem)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.PaymentResponseItem");
    }

    @Override
    public PaymentLog createLog() {
        return (PaymentLog)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.core.payment.domain.PaymentLog");
    }

    @Override
    public void delete(PaymentInfo paymentInfo) {
        if (!this.em.contains((Object)paymentInfo)) {
            paymentInfo = this.readPaymentInfoById(paymentInfo.getId());
        }
        this.em.remove((Object)paymentInfo);
    }
}

