/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerAddressDao;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerAddressDao")
public class CustomerAddressDaoImpl
implements CustomerAddressDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public List<CustomerAddress> readActiveCustomerAddressesByCustomerId(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_ACTIVE_CUSTOMER_ADDRESSES_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public CustomerAddress save(CustomerAddress customerAddress) {
        return (CustomerAddress)this.em.merge((Object)customerAddress);
    }

    @Override
    public CustomerAddress create() {
        return (CustomerAddress)this.entityConfiguration.createEntityInstance(CustomerAddress.class.getName());
    }

    @Override
    public CustomerAddress readCustomerAddressById(Long customerAddressId) {
        return (CustomerAddress)this.em.find(this.entityConfiguration.lookupEntityClass(CustomerAddress.class.getName()), (Object)customerAddressId);
    }

    @Override
    public void makeCustomerAddressDefault(Long customerAddressId, Long customerId) {
        List<CustomerAddress> customerAddresses = this.readActiveCustomerAddressesByCustomerId(customerId);
        for (CustomerAddress customerAddress : customerAddresses) {
            customerAddress.getAddress().setDefault(customerAddress.getId().equals(customerAddressId));
            this.em.merge((Object)customerAddress);
        }
    }

    @Override
    public void deleteCustomerAddressById(Long customerAddressId) {
        CustomerAddress customerAddress = this.readCustomerAddressById(customerAddressId);
        if (customerAddress != null) {
            this.em.remove((Object)customerAddress);
        }
    }

    @Override
    public CustomerAddress findDefaultCustomerAddress(Long customerId) {
        Query query = this.em.createNamedQuery("BC_FIND_DEFAULT_ADDRESS_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        List customerAddresses = query.getResultList();
        return customerAddresses.isEmpty() ? null : (CustomerAddress)customerAddresses.get(0);
    }
}

