/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class LocaleType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, LocaleType> TYPES = new HashMap<String, LocaleType>();
    public static final LocaleType US_ENGLISH = new LocaleType("en_US", "US English", Locale.US);
    public static final LocaleType CANADA = new LocaleType("en_CA", "Canada English", Locale.CANADA);
    public static final LocaleType CANADA_FRENCH = new LocaleType("fr_CA", "Canada French", Locale.CANADA_FRENCH);
    public static final LocaleType CHINA = new LocaleType("zh_CN", "China", Locale.CHINA);
    public static final LocaleType CHINA_ENGLISH = new LocaleType("en_CN", "China English", new Locale("CN", "en"));
    public static final LocaleType FRANCE = new LocaleType("fr_FR", "France", Locale.FRANCE);
    public static final LocaleType FRANCE_ENGLISH = new LocaleType("en_FR", "France English", new Locale("FR", "en"));
    public static final LocaleType GERMANY = new LocaleType("de_DE", "Germany", Locale.GERMANY);
    public static final LocaleType GERMANY_ENGLISH = new LocaleType("en_DE", "Germany English", new Locale("DE", "en"));
    public static final LocaleType ITALY = new LocaleType("it_IT", "Italy", Locale.ITALY);
    public static final LocaleType ITALY_ENGLISH = new LocaleType("en_IT", "Italy English", new Locale("IT", "en"));
    public static final LocaleType JAPAN = new LocaleType("ja_JP", "Japan", Locale.JAPAN);
    public static final LocaleType JAPAN_ENGLISH = new LocaleType("en_JP", "Japan English", new Locale("JP", "en"));
    public static final LocaleType KOREA = new LocaleType("ko_KR", "Korea", Locale.KOREA);
    public static final LocaleType KOREA_ENGLISH = new LocaleType("en_KR", "Korea English", new Locale("KR", "en"));
    public static final LocaleType INDIA_HINDI = new LocaleType("hi_IN", "India Hindi", new Locale("IN", "hi"));
    public static final LocaleType INDIA_ENGLISH = new LocaleType("en_IN", "India English", new Locale("IN", "en"));
    public static final LocaleType UK_ENGLISH = new LocaleType("en_UK", "UK English", Locale.UK);
    public static final LocaleType TAIWAN = new LocaleType("zh_TW", "Taiwan", Locale.TAIWAN);
    public static final LocaleType TAIWAN_ENGLISH = new LocaleType("en_TW", "Taiwan English", new Locale("TW", "en"));
    private String type;
    private String friendlyType;
    private Locale locale;

    public static void main(String[] items) {
        System.out.println(Locale.TAIWAN.toString());
    }

    public static LocaleType getInstance(String type) {
        return TYPES.get(type);
    }

    public LocaleType() {
    }

    public LocaleType(String type, String friendlyType, Locale locale) {
        this.friendlyType = friendlyType;
        this.locale = locale;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocaleType other = (LocaleType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

