/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.persistence.spi.PersistenceUnitInfo;
import org.springframework.util.ClassUtils;

public class Jpa2PersistenceUnitInfoDecorator
implements InvocationHandler {
    private final PersistenceUnitInfo target;
    private final Class<? extends Enum> sharedCacheModeEnum;
    private final Class<? extends Enum> validationModeEnum;

    public Jpa2PersistenceUnitInfoDecorator(PersistenceUnitInfo target) {
        this.target = target;
        try {
            this.sharedCacheModeEnum = ClassUtils.forName((String)"javax.persistence.SharedCacheMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
            this.validationModeEnum = ClassUtils.forName((String)"javax.persistence.ValidationMode", (ClassLoader)PersistenceUnitInfo.class.getClassLoader());
        }
        catch (Exception ex) {
            throw new IllegalStateException("JPA 2.0 API enum types not present", ex);
        }
    }

    public final PersistenceUnitInfo getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getSharedCacheMode")) {
            return Enum.valueOf(this.sharedCacheModeEnum, (String)this.target.getClass().getMethod("getSharedCacheModeName", new Class[0]).invoke((Object)this.target, new Object[0]));
        }
        if (method.getName().equals("getValidationMode")) {
            return Enum.valueOf(this.validationModeEnum, (String)this.target.getClass().getMethod("getValidationModeName", new Class[0]).invoke((Object)this.target, new Object[0]));
        }
        return method.invoke((Object)this.target, args);
    }
}

