/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.math.BigDecimal;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.SkuDaoDataProvider;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class SkuDaoTest
extends BaseTest {
    private Long skuId;
    @Resource
    private SkuDao skuDao;
    @Resource
    private CatalogService catalogService;

    @Test(groups={"createSku"}, dataProvider="basicSku", dataProviderClass=SkuDaoDataProvider.class, dependsOnGroups={"readCustomer", "createOrder", "createProducts"})
    @Rollback(value=false)
    public void createSku(Sku sku) {
        sku.setSalePrice(new Money(BigDecimal.valueOf(10.0)));
        sku.setRetailPrice(new Money(BigDecimal.valueOf(15.0)));
        sku.setName("test sku");
        assert (sku.getId() == null);
        sku = this.catalogService.saveSku(sku);
        assert (sku.getId() != null);
        this.skuId = sku.getId();
    }

    @Test(groups={"readFirstSku"}, dependsOnGroups={"createSku"})
    @Transactional
    public void readFirstSku() {
        Sku si = this.skuDao.readFirstSku();
        assert (si != null);
        assert (si.getId() != null);
    }

    @Test(groups={"readSkuById"}, dependsOnGroups={"createSku"})
    @Transactional
    public void readSkuById() {
        Sku item = this.skuDao.readSkuById(this.skuId);
        assert (item != null);
        assert (item.getId() == this.skuId);
    }
}

