/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.broadleafcommerce.common.extensibility.context.MergeApplicationContextXmlConfigResource;
import org.broadleafcommerce.common.extensibility.context.MergeClassPathXMLApplicationContext;
import org.broadleafcommerce.common.extensibility.context.ResourceInputStream;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.core.io.Resource;

public class MergeFileSystemAndClassPathXMLApplicationContext
extends AbstractXmlApplicationContext {
    protected Resource[] configResources;

    protected Resource[] getConfigResources() {
        return this.configResources;
    }

    public MergeFileSystemAndClassPathXMLApplicationContext(String[] classPathLocations, String[] fileSystemLocations) throws BeansException {
        this(classPathLocations, fileSystemLocations, null);
    }

    public MergeFileSystemAndClassPathXMLApplicationContext(String[] classPathLocations, String[] fileSystemLocations, ApplicationContext parent) throws BeansException {
        super(parent);
        ResourceInputStream[] fileSystemSources;
        ResourceInputStream[] classPathSources;
        try {
            int j;
            classPathSources = new ResourceInputStream[classPathLocations.length];
            for (j = 0; j < classPathLocations.length; ++j) {
                classPathSources[j] = new ResourceInputStream(MergeClassPathXMLApplicationContext.class.getClassLoader().getResourceAsStream(classPathLocations[j]), classPathLocations[j]);
            }
            fileSystemSources = new ResourceInputStream[fileSystemLocations.length];
            for (j = 0; j < fileSystemSources.length; ++j) {
                File temp = new File(fileSystemLocations[j]);
                fileSystemSources[j] = new ResourceInputStream(new BufferedInputStream(new FileInputStream(temp)), fileSystemLocations[j]);
            }
        }
        catch (FileNotFoundException e) {
            throw new FatalBeanException("Unable to merge context files", (Throwable)e);
        }
        this.configResources = new MergeApplicationContextXmlConfigResource().getConfigResources(classPathSources, fileSystemSources);
        this.refresh();
    }
}

