/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context.merge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extensibility.context.ResourceInputStream;
import org.broadleafcommerce.common.extensibility.context.merge.MergeManager;
import org.broadleafcommerce.common.extensibility.context.merge.exceptions.MergeException;
import org.broadleafcommerce.common.extensibility.context.merge.exceptions.MergeManagerSetupException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class MergeXmlConfigResource {
    private static final Log LOG = LogFactory.getLog(MergeXmlConfigResource.class);

    public Resource getMergedConfigResource(ResourceInputStream[] sources) throws BeansException {
        ByteArrayResource configResource = null;
        ResourceInputStream merged = null;
        try {
            merged = this.merge(sources);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean eof = false;
            while (!eof) {
                int temp = merged.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                baos.write(temp);
            }
            configResource = new ByteArrayResource(baos.toByteArray());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merged config: \n" + this.serialize((Resource)configResource)));
            }
        }
        catch (MergeException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (MergeManagerSetupException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        finally {
            if (merged != null) {
                try {
                    merged.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return configResource;
    }

    protected ResourceInputStream merge(ResourceInputStream[] sources) throws MergeException, MergeManagerSetupException {
        if (sources.length == 1) {
            return sources[0];
        }
        ResourceInputStream response = null;
        ResourceInputStream[] pair = new ResourceInputStream[2];
        pair[0] = sources[0];
        for (int j = 1; j < sources.length; ++j) {
            pair[1] = sources[j];
            response = this.mergeItems(pair);
            try {
                pair[0].close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Unable to merge source and patch locations", e);
            }
            try {
                pair[1].close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Unable to merge source and patch locations", e);
            }
            pair[0] = response;
        }
        return response;
    }

    protected ResourceInputStream mergeItems(ResourceInputStream[] sourceLocations) throws MergeException, MergeManagerSetupException {
        ResourceInputStream response = new MergeManager().merge(sourceLocations[0], sourceLocations[1]);
        return response;
    }

    public String serialize(Resource resource) {
        String response = "";
        try {
            response = this.serialize(resource.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to merge source and patch locations", (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize(InputStream in) {
        InputStreamReader reader = null;
        StringBuffer item = new StringBuffer();
        boolean eof = false;
        try {
            reader = new InputStreamReader(in);
            while (!eof) {
                int temp = reader.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                item.append((char)temp);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to merge source and patch locations", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return item.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] buildArrayFromStream(InputStream source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean eof = false;
        try {
            while (!eof) {
                int temp = source.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                baos.write(temp);
            }
        }
        finally {
            try {
                source.close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Unable to merge source and patch locations", e);
            }
        }
        return baos.toByteArray();
    }
}

