/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context.merge.handlers;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extensibility.context.merge.handlers.BaseHandler;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InsertItems
extends BaseHandler {
    private static final Log LOG = LogFactory.getLog(InsertItems.class);

    @Override
    public Node[] merge(NodeList nodeList1, NodeList nodeList2, List<Node> exhaustedNodes) {
        if (nodeList1 == null || nodeList2 == null || nodeList1.getLength() == 0 || nodeList2.getLength() == 0) {
            return null;
        }
        ArrayList<Node> usedNodes = new ArrayList<Node>();
        Node node1Parent = nodeList1.item(0).getParentNode();
        for (int j = 0; j < nodeList2.getLength(); ++j) {
            int x;
            int attrLength;
            StringBuffer sb;
            Node tempNode = node1Parent.getOwnerDocument().importNode(nodeList2.item(j).cloneNode(true), true);
            if (LOG.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("matching node for insertion: ");
                sb.append(tempNode.getNodeName());
                attrLength = tempNode.getAttributes().getLength();
                for (x = 0; x < attrLength; ++x) {
                    sb.append(" : (");
                    sb.append(tempNode.getAttributes().item(x).getNodeName());
                    sb.append("/");
                    sb.append(tempNode.getAttributes().item(x).getNodeValue());
                    sb.append(")");
                }
                LOG.debug((Object)sb.toString());
            }
            if (LOG.isDebugEnabled()) {
                sb = new StringBuffer();
                sb.append("inserting into parent: ");
                sb.append(node1Parent.getNodeName());
                attrLength = node1Parent.getAttributes().getLength();
                for (x = 0; x < attrLength; ++x) {
                    sb.append(" : (");
                    sb.append(node1Parent.getAttributes().item(x).getNodeName());
                    sb.append("/");
                    sb.append(node1Parent.getAttributes().item(x).getNodeValue());
                    sb.append(")");
                }
                LOG.debug((Object)sb.toString());
            }
            node1Parent.appendChild(tempNode);
            usedNodes.add(tempNode);
        }
        Node[] response = new Node[]{nodeList2.item(0).getParentNode()};
        return response;
    }
}

