/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.persistence;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="blEntityConfiguration")
public class EntityConfiguration {
    private static final Log LOG = LogFactory.getLog(EntityConfiguration.class);
    private final HashMap<String, Class<?>> entityMap = new HashMap(50);
    private ApplicationContext applicationcontext;
    private Resource[] entityContexts;

    public Class<?> lookupEntityClass(String beanId) {
        Class<?> clazz;
        if (this.entityMap.containsKey(beanId)) {
            clazz = this.entityMap.get(beanId);
        } else {
            Object object = this.applicationcontext.getBean(beanId);
            clazz = object.getClass();
            this.entityMap.put(beanId, clazz);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning class (" + clazz.getName() + ") configured with bean id (" + beanId + ')'));
        }
        return clazz;
    }

    public <T> Class<T> lookupEntityClass(String beanId, Class<T> resultClass) {
        Class<?> clazz;
        if (this.entityMap.containsKey(beanId)) {
            clazz = this.entityMap.get(beanId);
        } else {
            Object object = this.applicationcontext.getBean(beanId);
            clazz = object.getClass();
            this.entityMap.put(beanId, clazz);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning class (" + clazz.getName() + ") configured with bean id (" + beanId + ')'));
        }
        return clazz;
    }

    public Object createEntityInstance(String beanId) {
        Object bean = this.applicationcontext.getBean(beanId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning instance of class (" + bean.getClass().getName() + ") configured with bean id (" + beanId + ')'));
        }
        return bean;
    }

    public <T> T createEntityInstance(String beanId, Class<T> resultClass) {
        Object bean = this.applicationcontext.getBean(beanId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning instance of class (" + bean.getClass().getName() + ") configured with bean id (" + beanId + ')'));
        }
        return (T)bean;
    }

    public Resource[] getEntityContexts() {
        return this.entityContexts;
    }

    public void setEntityContexts(Resource[] entityContexts) {
        this.entityContexts = entityContexts;
        this.applicationcontext = new GenericXmlApplicationContext(entityContexts);
    }
}

