/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.security;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.security.web.RedirectStrategy;

public class LocalRedirectStrategy
implements RedirectStrategy {
    private boolean contextRelative = false;
    private Logger logger = Logger.getLogger(this.getClass());
    private boolean enforcePortMatch = false;

    public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (!url.startsWith("/") && (StringUtils.equals((String)request.getParameter("successUrl"), (String)url) || StringUtils.equals((String)request.getParameter("failureUrl"), (String)url))) {
            this.validateRedirectUrl(request.getContextPath(), url, request.getServerName(), request.getServerPort());
        }
        String redirectUrl = this.calculateRedirectUrl(request.getContextPath(), url);
        redirectUrl = response.encodeRedirectURL(redirectUrl);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Redirecting to '" + url + "'"));
        }
        response.sendRedirect(redirectUrl);
    }

    protected String calculateRedirectUrl(String contextPath, String url) {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            if (this.contextRelative) {
                return url;
            }
            return contextPath + url;
        }
        if (!this.contextRelative) {
            return url;
        }
        url = url.substring(url.indexOf("://") + 3);
        if ((url = url.substring(url.indexOf(contextPath) + contextPath.length())).length() > 1 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    private void validateRedirectUrl(String contextPath, String url, String requestServerName, int requestServerPort) throws MalformedURLException {
        URL urlObject = new URL(url);
        if ((urlObject.getProtocol().equals("http") || urlObject.getProtocol().equals("https")) && StringUtils.equals((String)requestServerName, (String)urlObject.getHost()) && (!this.enforcePortMatch || requestServerPort == urlObject.getPort()) && (StringUtils.isEmpty((String)contextPath) || urlObject.getPath().startsWith("/" + contextPath))) {
            return;
        }
        String errorMessage = "Invalid redirect url specified.  Must be of the form /<relative view> or http[s]://<server name>[:<server port>][/<context path>]/...";
        this.logger.warn((Object)(errorMessage + ":  " + url));
        throw new MalformedURLException(errorMessage + ":  " + url);
    }

    public void setEnforcePortMatch(boolean enforcePortMatch) {
        this.enforcePortMatch = enforcePortMatch;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }
}

