/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util;

public class Mod43CheckDigitUtil {
    private static final String CHARSET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%";

    public static boolean isValidCheckedValue(String value) {
        boolean valid = false;
        if (value != null && !"".equals(value)) {
            String code = value.substring(0, value.length() - 1);
            char checkDigit = value.substring(value.length() - 1).charAt(0);
            try {
                if (Mod43CheckDigitUtil.generateCheckDigit(code) == checkDigit) {
                    valid = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return valid;
    }

    public static char generateCheckDigit(String data) {
        int sum = 0;
        for (int i = 0; i < data.length(); ++i) {
            sum += CHARSET.indexOf(data.charAt(i));
        }
        int remainder = sum % 43;
        return CHARSET.charAt(remainder);
    }

    public static void main(String[] args) {
        try {
            System.out.println(Mod43CheckDigitUtil.generateCheckDigit("TEACH000012345"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(Mod43CheckDigitUtil.isValidCheckedValue("TEACH000012345B"));
    }
}

