/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util.sql;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.PropertySet;
import org.broadleafcommerce.common.util.sql.HibernateToolTask;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2x.Exporter;

public abstract class ExporterTask {
    protected HibernateToolTask parent;
    Properties properties;
    File destdir;
    Configuration configuration;
    String outputFileName = null;

    public ExporterTask(HibernateToolTask parent) {
        this.parent = parent;
        this.properties = new Properties();
    }

    public void execute() {
        Exporter exporter = this.configureExporter(this.createExporter());
        exporter.start();
    }

    protected abstract Exporter createExporter();

    public File getDestdir() {
        return this.destdir;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void addConfiguredPropertySet(PropertySet ps) {
        this.properties.putAll((Map<?, ?>)ps.getProperties());
    }

    public void addConfiguredProperty(Environment.Variable property) {
        this.properties.put(property.getKey(), property.getValue());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setOutputFileName(String fileName) {
        this.outputFileName = fileName;
    }

    abstract String getName();

    abstract Exporter configureExporter(Exporter var1);
}

