/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.util.sql;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.tools.ant.BuildException;
import org.broadleafcommerce.common.extensibility.context.MergeFileSystemAndClassPathXMLApplicationContext;
import org.broadleafcommerce.common.extensibility.jpa.MergePersistenceUnitManager;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.ant.ConfigurationTask;
import org.hibernate.util.ReflectHelper;
import org.xml.sax.EntityResolver;

public class JPAConfigurationTask
extends ConfigurationTask {
    private String persistenceUnit;
    private String dialect;

    public JPAConfigurationTask() {
        this.setDescription("JPA Configuration");
    }

    protected Configuration createConfiguration(MergeFileSystemAndClassPathXMLApplicationContext mergeContext) {
        try {
            PersistenceUnitInfo unitInfo = ((MergePersistenceUnitManager)((Object)mergeContext.getBean("blPersistenceUnitManager"))).obtainPersistenceUnitInfo(this.persistenceUnit);
            HashMap<Object, Object> overrides = new HashMap<Object, Object>();
            Properties p = this.getProperties();
            if (p != null) {
                overrides.putAll(p);
            }
            overrides.put("hibernate.dialect", this.dialect);
            Class clazz = ReflectHelper.classForName((String)"org.hibernate.ejb.Ejb3Configuration", JPAConfigurationTask.class);
            Object ejb3cfg = clazz.newInstance();
            if (this.entityResolver != null) {
                Class resolver = ReflectHelper.classForName((String)this.entityResolver, ((Object)((Object)this)).getClass());
                Object object = resolver.newInstance();
                Method method = clazz.getMethod("setEntityResolver", EntityResolver.class);
                method.invoke(ejb3cfg, object);
            }
            Method method = clazz.getMethod("configure", PersistenceUnitInfo.class, Map.class);
            if (method.invoke(ejb3cfg, unitInfo, overrides) == null) {
                throw new BuildException("Persistence unit not found: '" + this.persistenceUnit + "'.");
            }
            method = clazz.getMethod("getHibernateConfiguration", new Class[0]);
            return (Configuration)method.invoke(ejb3cfg, (Object[])null);
        }
        catch (HibernateException he) {
            throw new BuildException((Throwable)he);
        }
        catch (BuildException be) {
            throw be;
        }
        catch (Exception t) {
            throw new BuildException("Problems in creating a configuration for JPA. Have you remembered to add hibernate EntityManager jars to the classpath ?", (Throwable)t);
        }
    }

    protected void doConfiguration(Configuration configuration) {
    }

    protected void validateParameters() throws BuildException {
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }
}

