/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.web.extensibility;

import javax.servlet.ServletContext;
import org.broadleafcommerce.common.web.extensibility.MergeXmlWebApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class MergeContextLoader
extends ContextLoader {
    public static final String PATCH_LOCATION_PARAM = "patchConfigLocation";
    public static final String SHUTDOWN_HOOK_BEAN = "shutdownHookBean";
    public static final String SHUTDOWN_HOOK_METHOD = "shutdownHookMethod";

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext, ApplicationContext parent) throws BeansException {
        MergeXmlWebApplicationContext wac = new MergeXmlWebApplicationContext();
        wac.setParent(parent);
        wac.setServletContext(servletContext);
        wac.setConfigLocation(servletContext.getInitParameter("contextConfigLocation"));
        wac.setPatchLocation(servletContext.getInitParameter(PATCH_LOCATION_PARAM));
        wac.setShutdownBean(servletContext.getInitParameter(SHUTDOWN_HOOK_BEAN));
        wac.setShutdownMethod(servletContext.getInitParameter(SHUTDOWN_HOOK_METHOD));
        this.customizeContext(servletContext, (ConfigurableWebApplicationContext)wac);
        wac.refresh();
        return wac;
    }
}

