/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class OfferDeliveryType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, OfferDeliveryType> TYPES = new HashMap<String, OfferDeliveryType>();
    public static final OfferDeliveryType AUTOMATIC = new OfferDeliveryType("AUTOMATIC", "Automatic");
    public static final OfferDeliveryType MANUAL = new OfferDeliveryType("MANUAL", "Manual");
    public static final OfferDeliveryType CODE = new OfferDeliveryType("CODE", "Code");
    private String type;
    private String friendlyType;

    public static OfferDeliveryType getInstance(String type) {
        return TYPES.get(type);
    }

    public OfferDeliveryType() {
    }

    public OfferDeliveryType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferDeliveryType other = (OfferDeliveryType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

