/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemFeePriceImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitor;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_DISCRETE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="discreteOrderItem")
public class DiscreteOrderItemImpl
extends OrderItemImpl
implements DiscreteOrderItem {
    private static final long serialVersionUID = 1L;
    @Column(name="BASE_RETAIL_PRICE")
    @AdminPresentation(friendlyName="Base Retail Price", order=2, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseRetailPrice;
    @Column(name="BASE_SALE_PRICE")
    @AdminPresentation(friendlyName="Base Sale Price", order=2, group="Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseSalePrice;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false)
    @JoinColumn(name="SKU_ID", nullable=false)
    @Index(name="DISCRETE_SKU_INDEX", columnNames={"SKU_ID"})
    protected Sku sku;
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="DISCRETE_PRODUCT_INDEX", columnNames={"PRODUCT_ID"})
    @NotFound(action=NotFoundAction.IGNORE)
    protected Product product;
    @ManyToOne(targetEntity=BundleOrderItemImpl.class)
    @JoinColumn(name="BUNDLE_ORDER_ITEM_ID")
    @Index(name="DISCRETE_BUNDLE_INDEX", columnNames={"BUNDLE_ORDER_ITEM_ID"})
    protected BundleOrderItem bundleOrderItem;
    @CollectionOfElements
    @JoinTable(name="BLC_ORDER_ITEM_ADD_ATTR", joinColumns={@JoinColumn(name="ORDER_ITEM_ID")})
    @MapKey(columns={@Column(name="NAME", nullable=false)})
    @Column(name="VALUE")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOrderElements")
    @BatchSize(size=50)
    protected Map<String, String> additionalAttributes = new HashMap<String, String>();
    @OneToMany(mappedBy="discreteOrderItem", targetEntity=DiscreteOrderItemFeePriceImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<DiscreteOrderItemFeePrice> discreteOrderItemFeePrices = new ArrayList<DiscreteOrderItemFeePrice>();

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
        if (sku.getRetailPrice() != null) {
            this.baseRetailPrice = sku.getRetailPrice().getAmount();
        }
        if (sku.getSalePrice() != null) {
            this.baseSalePrice = sku.getSalePrice().getAmount();
        }
        this.setName(sku.getName());
    }

    @Override
    public Money getTaxablePrice() {
        Money taxablePrice = new Money(0.0);
        if (this.sku.isTaxable() == null || this.sku.isTaxable().booleanValue()) {
            taxablePrice = this.getPrice();
        }
        return taxablePrice;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public BundleOrderItem getBundleOrderItem() {
        return this.bundleOrderItem;
    }

    @Override
    public void setBundleOrderItem(BundleOrderItem bundleOrderItem) {
        this.bundleOrderItem = bundleOrderItem;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null) {
            return this.sku.getName();
        }
        return name;
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        if (!this.getSku().getRetailPrice().equals(this.getRetailPrice())) {
            this.setBaseRetailPrice(this.getSku().getRetailPrice());
            this.setRetailPrice(this.getSku().getRetailPrice());
            updated = true;
        }
        if (this.getSku().getSalePrice() != null && !this.getSku().getSalePrice().equals(this.getSalePrice())) {
            this.setBaseSalePrice(this.getSku().getSalePrice());
            this.setSalePrice(this.getSku().getSalePrice());
            updated = true;
        }
        if (this.getDiscreteOrderItemFeePrices() != null) {
            for (DiscreteOrderItemFeePrice fee : this.getDiscreteOrderItemFeePrices()) {
                this.setSalePrice(this.getSalePrice().add(fee.getAmount()));
                this.setRetailPrice(this.getRetailPrice().add(fee.getAmount()));
            }
        }
        return updated;
    }

    @Override
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Override
    public void setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Override
    public Money getBaseRetailPrice() {
        return this.baseRetailPrice != null ? new Money(this.baseRetailPrice) : null;
    }

    @Override
    public void setBaseRetailPrice(Money baseRetailPrice) {
        this.baseRetailPrice = baseRetailPrice.getAmount();
    }

    @Override
    public Money getBaseSalePrice() {
        return this.baseSalePrice != null ? new Money(this.baseRetailPrice) : null;
    }

    @Override
    public void setBaseSalePrice(Money baseSalePrice) {
        this.baseSalePrice = baseSalePrice == null ? null : baseSalePrice.getAmount();
    }

    @Override
    public List<DiscreteOrderItemFeePrice> getDiscreteOrderItemFeePrices() {
        return this.discreteOrderItemFeePrices;
    }

    @Override
    public void setDiscreteOrderItemFeePrices(List<DiscreteOrderItemFeePrice> discreteOrderItemFeePrices) {
        this.discreteOrderItemFeePrices = discreteOrderItemFeePrices;
    }

    @Override
    public OrderItem clone() {
        DiscreteOrderItem orderItem = (DiscreteOrderItem)super.clone();
        if (this.getDiscreteOrderItemFeePrices() != null) {
            for (DiscreteOrderItemFeePrice feePrice : this.getDiscreteOrderItemFeePrices()) {
                DiscreteOrderItemFeePrice cloneFeePrice = feePrice.clone();
                cloneFeePrice.setDiscreteOrderItem(orderItem);
                orderItem.getDiscreteOrderItemFeePrices().add(cloneFeePrice);
            }
        }
        if (this.getAdditionalAttributes() != null) {
            orderItem.getAdditionalAttributes().putAll(this.getAdditionalAttributes());
        }
        orderItem.setBaseRetailPrice(this.getBaseRetailPrice());
        orderItem.setBaseSalePrice(this.getBaseSalePrice());
        orderItem.setBundleOrderItem(this.getBundleOrderItem());
        orderItem.setProduct(this.getProduct());
        orderItem.setSku(this.getSku());
        return orderItem;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiscreteOrderItemImpl other = (DiscreteOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.bundleOrderItem == null ? other.bundleOrderItem != null : !this.bundleOrderItem.equals(other.bundleOrderItem)) {
            return false;
        }
        return !(this.sku == null ? other.sku != null : !this.sku.equals(other.sku));
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = 1;
        result = prime * result + (this.bundleOrderItem == null ? 0 : this.bundleOrderItem.hashCode());
        result = prime * result + (this.sku == null ? 0 : this.sku.hashCode());
        return result;
    }

    @Override
    public void accept(OrderItemVisitor visitor) throws PricingException {
        visitor.visit(this);
    }
}

