/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.domain.OfferInfo;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.OrderServiceImpl;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.call.ReconstructCartResponse;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Service;

@Service(value="blCartService")
@ManagedResource(objectName="org.broadleafcommerce:name=CartService", description="Cart Service", currencyTimeLimit=15)
public class CartServiceImpl
extends OrderServiceImpl
implements CartService {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    protected boolean moveNamedOrderItems = true;
    protected boolean deleteEmptyNamedOrders = true;

    @Override
    public Order createNewCartForCustomer(Customer customer) {
        return this.orderDao.createNewCartForCustomer(customer);
    }

    @Override
    public Order findCartForCustomer(Customer customer) {
        return this.orderDao.readCartForCustomer(customer);
    }

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.addAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order addAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        ArrayList<OrderItem> items = new ArrayList<OrderItem>(namedOrder.getOrderItems());
        for (int i = 0; i < items.size(); ++i) {
            boolean shouldPriceOrder;
            OrderItem orderItem = (OrderItem)items.get(i);
            boolean bl = shouldPriceOrder = priceOrder && i == items.size() - 1;
            if (this.moveNamedOrderItems) {
                this.moveItemToOrder(namedOrder, cartOrder, orderItem, shouldPriceOrder);
                continue;
            }
            this.addOrderItemToOrder(cartOrder, orderItem, shouldPriceOrder);
        }
        return cartOrder;
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity) throws PricingException {
        return this.moveItemToCartFromNamedOrder(customerId, orderName, orderItemId, quantity, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Long customerId, String orderName, Long orderItemId, Integer quantity, boolean priceOrder) throws PricingException {
        Order wishlistOrder = this.findNamedOrderForCustomer(orderName, this.customerService.createCustomerFromId(customerId));
        OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
        orderItem.setQuantity(quantity);
        return this.moveItemToCartFromNamedOrder(wishlistOrder, orderItem, priceOrder);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem) throws PricingException {
        return this.moveItemToCartFromNamedOrder(namedOrder, orderItem, true);
    }

    @Override
    public OrderItem moveItemToCartFromNamedOrder(Order namedOrder, OrderItem orderItem, boolean priceOrder) throws PricingException {
        Order cartOrder = this.orderDao.readCartForCustomer(namedOrder.getCustomer());
        if (cartOrder == null) {
            cartOrder = this.createNewCartForCustomer(namedOrder.getCustomer());
        }
        if (this.moveNamedOrderItems) {
            this.moveItemToOrder(namedOrder, cartOrder, orderItem, priceOrder);
            if (namedOrder.getOrderItems().size() == 0 && this.deleteEmptyNamedOrders) {
                this.cancelOrder(namedOrder);
            }
        } else {
            orderItem = this.addOrderItemToOrder(cartOrder, orderItem, priceOrder);
        }
        return orderItem;
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder) throws PricingException {
        return this.moveAllItemsToCartFromNamedOrder(namedOrder, true);
    }

    @Override
    public Order moveAllItemsToCartFromNamedOrder(Order namedOrder, boolean priceOrder) throws PricingException {
        Order cartOrder = this.addAllItemsToCartFromNamedOrder(namedOrder, priceOrder);
        if (this.deleteEmptyNamedOrders) {
            this.cancelOrder(namedOrder);
        }
        return cartOrder;
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart) throws PricingException {
        return this.mergeCart(customer, anonymousCart, true);
    }

    @Override
    public MergeCartResponse mergeCart(Customer customer, Order anonymousCart, boolean priceOrder) throws PricingException {
        MergeCartResponse mergeCartResponse = new MergeCartResponse();
        ReconstructCartResponse reconstructCartResponse = this.reconstructCart(customer, false);
        mergeCartResponse.setRemovedItems(reconstructCartResponse.getRemovedItems());
        Order customerCart = reconstructCartResponse.getOrder();
        if (anonymousCart != null && customerCart != null && anonymousCart.getId().equals(customerCart.getId())) {
            mergeCartResponse.setMerged(false);
        } else {
            mergeCartResponse.setMerged(customerCart != null && customerCart.getOrderItems().size() > 0);
        }
        if (!(anonymousCart == null || customerCart != null && customerCart.getId().equals(anonymousCart.getId()) || anonymousCart == null || anonymousCart.getOrderItems() == null || anonymousCart.getOrderItems().isEmpty())) {
            if (customerCart == null) {
                customerCart = this.createNewCartForCustomer(customer);
            }
            HashMap<OrderItem, OrderItem> oldNewItemMap = new HashMap<OrderItem, OrderItem>();
            customerCart = this.mergeRegularOrderItems(anonymousCart, mergeCartResponse, customerCart, oldNewItemMap);
            customerCart = this.mergeOfferCodes(anonymousCart, customerCart);
            customerCart = this.removeExpiredGiftWrapOrderItems(mergeCartResponse, customerCart, oldNewItemMap);
            customerCart = this.mergeGiftWrapOrderItems(mergeCartResponse, customerCart, oldNewItemMap);
            customerCart = this.save(customerCart, priceOrder);
            this.cancelOrder(anonymousCart);
        }
        mergeCartResponse.setOrder(customerCart);
        return mergeCartResponse;
    }

    protected Order mergeGiftWrapOrderItems(MergeCartResponse mergeCartResponse, Order customerCart, Map<OrderItem, OrderItem> oldNewItemMap) throws PricingException {
        Iterator<OrderItem> addedItems = mergeCartResponse.getAddedItems().iterator();
        while (addedItems.hasNext()) {
            OrderItem addedItem = addedItems.next();
            if (addedItem instanceof GiftWrapOrderItem) {
                GiftWrapOrderItem giftItem = (GiftWrapOrderItem)addedItem;
                ArrayList<OrderItem> itemsToAdd = new ArrayList<OrderItem>();
                Iterator<OrderItem> wrappedItems = giftItem.getWrappedItems().iterator();
                while (wrappedItems.hasNext()) {
                    OrderItem wrappedItem = wrappedItems.next();
                    if (!oldNewItemMap.containsKey(wrappedItem)) continue;
                    OrderItem newItem = oldNewItemMap.get(wrappedItem);
                    newItem.setGiftWrapOrderItem(giftItem);
                    itemsToAdd.add(newItem);
                    wrappedItem.setGiftWrapOrderItem(null);
                    wrappedItems.remove();
                }
                giftItem.getWrappedItems().addAll(itemsToAdd);
                continue;
            }
            if (!(addedItem instanceof BundleOrderItem)) continue;
            boolean isValidBundle = true;
            HashMap<String, DiscreteOrderItem> newItemsMap = new HashMap<String, DiscreteOrderItem>();
            for (DiscreteOrderItem newItem : ((BundleOrderItem)addedItem).getDiscreteOrderItems()) {
                newItemsMap.put(newItem.getSku().getId() + "_" + newItem.getPrice(), newItem);
            }
            block3: for (DiscreteOrderItem itemFromBundle : ((BundleOrderItem)addedItem).getDiscreteOrderItems()) {
                if (!(itemFromBundle instanceof GiftWrapOrderItem)) continue;
                GiftWrapOrderItem giftItem = (GiftWrapOrderItem)itemFromBundle;
                ArrayList<OrderItem> itemsToAdd = new ArrayList<OrderItem>();
                Iterator<OrderItem> wrappedItems = giftItem.getWrappedItems().iterator();
                while (wrappedItems.hasNext()) {
                    OrderItem wrappedItem = wrappedItems.next();
                    if (oldNewItemMap.containsKey(wrappedItem)) {
                        OrderItem newItem = oldNewItemMap.get(wrappedItem);
                        newItem.setGiftWrapOrderItem(giftItem);
                        itemsToAdd.add(newItem);
                        wrappedItem.setGiftWrapOrderItem(null);
                        wrappedItems.remove();
                        continue;
                    }
                    if (wrappedItem instanceof DiscreteOrderItem) {
                        DiscreteOrderItem discreteWrappedItem = (DiscreteOrderItem)wrappedItem;
                        String itemKey = discreteWrappedItem.getSku().getId() + "_" + discreteWrappedItem.getPrice();
                        if (newItemsMap.containsKey(itemKey)) {
                            OrderItem newItem = (OrderItem)newItemsMap.get(itemKey);
                            newItem.setGiftWrapOrderItem(giftItem);
                            itemsToAdd.add(newItem);
                            discreteWrappedItem.setGiftWrapOrderItem(null);
                            wrappedItems.remove();
                            continue;
                        }
                        isValidBundle = false;
                        break block3;
                    }
                    isValidBundle = false;
                    break block3;
                }
                giftItem.getWrappedItems().addAll(itemsToAdd);
            }
            if (isValidBundle) continue;
            customerCart = this.removeItemFromOrder(customerCart, addedItem, false);
            addedItems.remove();
            mergeCartResponse.getRemovedItems().add(addedItem);
        }
        for (OrderItem addedItem : mergeCartResponse.getAddedItems()) {
            if (!(addedItem instanceof BundleOrderItem)) continue;
            boolean containsGiftWrap = false;
            for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)addedItem).getDiscreteOrderItems()) {
                if (!(discreteOrderItem instanceof GiftWrapOrderItem)) continue;
                containsGiftWrap = true;
                break;
            }
            if (containsGiftWrap) continue;
            for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)addedItem).getDiscreteOrderItems()) {
                discreteOrderItem.setGiftWrapOrderItem(null);
            }
        }
        return customerCart;
    }

    protected Order removeExpiredGiftWrapOrderItems(MergeCartResponse mergeCartResponse, Order customerCart, Map<OrderItem, OrderItem> oldNewItemMap) throws PricingException {
        Iterator<OrderItem> addedItems = mergeCartResponse.getAddedItems().iterator();
        while (addedItems.hasNext()) {
            OrderItem addedItem = addedItems.next();
            if (!(addedItem instanceof GiftWrapOrderItem)) continue;
            GiftWrapOrderItem giftWrapOrderItem = (GiftWrapOrderItem)addedItem;
            boolean removeItem = false;
            for (OrderItem wrappedItem : giftWrapOrderItem.getWrappedItems()) {
                if (!mergeCartResponse.getRemovedItems().contains(wrappedItem)) continue;
                removeItem = true;
                break;
            }
            if (!removeItem) continue;
            for (OrderItem wrappedItem : giftWrapOrderItem.getWrappedItems()) {
                wrappedItem.setGiftWrapOrderItem(null);
            }
            giftWrapOrderItem.getWrappedItems().clear();
            for (OrderItem cartItem : customerCart.getOrderItems()) {
                if (cartItem.getGiftWrapOrderItem() == null || !oldNewItemMap.containsKey(cartItem.getGiftWrapOrderItem())) continue;
                cartItem.setGiftWrapOrderItem(null);
            }
            customerCart = this.removeItemFromOrder(customerCart, giftWrapOrderItem, false);
            addedItems.remove();
            mergeCartResponse.getRemovedItems().add(giftWrapOrderItem);
        }
        return customerCart;
    }

    protected Order mergeOfferCodes(Order anonymousCart, Order customerCart) {
        HashMap<String, OfferCode> customerOffersMap = new HashMap<String, OfferCode>();
        for (OfferCode customerOffer : customerCart.getAddedOfferCodes()) {
            customerOffersMap.put(customerOffer.getOfferCode(), customerOffer);
        }
        for (OfferCode anonymousOffer : anonymousCart.getAddedOfferCodes()) {
            if (customerOffersMap.containsKey(anonymousOffer.getOfferCode())) continue;
            OfferCode transferredCode = this.offerService.lookupOfferCodeByCode(anonymousOffer.getOfferCode());
            OfferInfo info = anonymousCart.getAdditionalOfferInformation().get(anonymousOffer.getOffer());
            OfferInfo offerInfo = this.offerDao.createOfferInfo();
            for (String key : info.getFieldValues().keySet()) {
                offerInfo.getFieldValues().put(key, info.getFieldValues().get(key));
            }
            customerCart.getAdditionalOfferInformation().put(transferredCode.getOffer(), offerInfo);
            customerCart.addOfferCode(transferredCode);
        }
        return customerCart;
    }

    protected Order mergeRegularOrderItems(Order anonymousCart, MergeCartResponse mergeCartResponse, Order customerCart, Map<OrderItem, OrderItem> oldNewItemMap) throws PricingException {
        for (OrderItem orderItem : anonymousCart.getOrderItems()) {
            if (orderItem instanceof DiscreteOrderItem) {
                orderItem.removeAllAdjustments();
                orderItem.removeAllCandidateItemOffers();
                DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
                if (discreteOrderItem.getSku().getActiveStartDate() != null) {
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) {
                        OrderItem newItem = this.addOrderItemToOrder(customerCart, (OrderItem)discreteOrderItem.clone(), false);
                        mergeCartResponse.getAddedItems().add(newItem);
                        oldNewItemMap.put(orderItem, newItem);
                        continue;
                    }
                    mergeCartResponse.getRemovedItems().add(orderItem);
                    continue;
                }
                if (discreteOrderItem.getProduct().isActive() && orderItem.getCategory().isActive()) {
                    OrderItem newItem = this.addOrderItemToOrder(customerCart, (OrderItem)discreteOrderItem.clone(), false);
                    mergeCartResponse.getAddedItems().add(newItem);
                    oldNewItemMap.put(orderItem, newItem);
                    continue;
                }
                mergeCartResponse.getRemovedItems().add(orderItem);
                continue;
            }
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
            orderItem.removeAllAdjustments();
            orderItem.removeAllCandidateItemOffers();
            boolean removeBundle = false;
            for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                discreteOrderItem.removeAllAdjustments();
                discreteOrderItem.removeAllCandidateItemOffers();
                if (discreteOrderItem.getSku().getActiveStartDate() != null) {
                    if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                    removeBundle = true;
                    continue;
                }
                if (discreteOrderItem.getProduct().isActive() && orderItem.getCategory().isActive()) continue;
                removeBundle = true;
            }
            if (!removeBundle) {
                OrderItem newItem = this.addOrderItemToOrder(customerCart, (OrderItem)bundleOrderItem.clone(), false);
                mergeCartResponse.getAddedItems().add(newItem);
                oldNewItemMap.put(orderItem, newItem);
                continue;
            }
            mergeCartResponse.getRemovedItems().add(orderItem);
        }
        return customerCart;
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer) throws PricingException {
        return this.reconstructCart(customer, true);
    }

    @Override
    public ReconstructCartResponse reconstructCart(Customer customer, boolean priceOrder) throws PricingException {
        ReconstructCartResponse reconstructCartResponse = new ReconstructCartResponse();
        Order customerCart = this.findCartForCustomer(customer);
        if (customerCart != null) {
            ArrayList<OrderItem> itemsToRemove = new ArrayList<OrderItem>();
            for (OrderItem orderItem : customerCart.getOrderItems()) {
                if (orderItem instanceof DiscreteOrderItem) {
                    DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
                    if (discreteOrderItem.getSku().getActiveStartDate() != null) {
                        if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                        itemsToRemove.add(orderItem);
                        continue;
                    }
                    if (discreteOrderItem.getProduct().isActive() && orderItem.getCategory().isActive()) continue;
                    itemsToRemove.add(orderItem);
                    continue;
                }
                if (!(orderItem instanceof BundleOrderItem)) continue;
                BundleOrderItem bundleOrderItem = (BundleOrderItem)orderItem;
                boolean removeBundle = false;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (discreteOrderItem.getSku().getActiveStartDate() != null) {
                        if (discreteOrderItem.getSku().isActive(discreteOrderItem.getProduct(), orderItem.getCategory())) continue;
                        removeBundle = true;
                        break;
                    }
                    if (discreteOrderItem.getProduct().isActive() && orderItem.getCategory().isActive()) continue;
                    removeBundle = true;
                    break;
                }
                if (!removeBundle) continue;
                itemsToRemove.add(orderItem);
            }
            block2: for (OrderItem orderItem : customerCart.getOrderItems()) {
                if (!(orderItem instanceof GiftWrapOrderItem)) continue;
                for (OrderItem wrappedItem : ((GiftWrapOrderItem)orderItem).getWrappedItems()) {
                    if (!itemsToRemove.contains(wrappedItem)) continue;
                    itemsToRemove.add(orderItem);
                    continue block2;
                }
            }
            for (OrderItem item : itemsToRemove) {
                this.removeItemFromOrder(customerCart, item, priceOrder);
            }
            reconstructCartResponse.setRemovedItems(itemsToRemove);
        }
        reconstructCartResponse.setOrder(customerCart);
        return reconstructCartResponse;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public boolean isMoveNamedOrderItems() {
        return this.moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The move item from named order when adding to the cart attribute", currencyTimeLimit=15)
    public void setMoveNamedOrderItems(boolean moveNamedOrderItems) {
        this.moveNamedOrderItems = moveNamedOrderItems;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public boolean isDeleteEmptyNamedOrders() {
        return this.deleteEmptyNamedOrders;
    }

    @Override
    @ManagedAttribute(description="The delete empty named order after adding items to cart attribute", currencyTimeLimit=15)
    public void setDeleteEmptyNamedOrders(boolean deleteEmptyNamedOrders) {
        this.deleteEmptyNamedOrders = deleteEmptyNamedOrders;
    }
}

