/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class TransactionType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, TransactionType> TYPES = new HashMap<String, TransactionType>();
    public static final TransactionType AUTHORIZE = new TransactionType("AUTHORIZE", "Authorize");
    public static final TransactionType DEBIT = new TransactionType("DEBIT", "Debit");
    public static final TransactionType AUTHORIZEANDDEBIT = new TransactionType("AUTHORIZEANDDEBIT", "Authorize and Debit");
    public static final TransactionType CREDIT = new TransactionType("CREDIT", "Credit");
    public static final TransactionType VOIDPAYMENT = new TransactionType("VOIDPAYMENT", "Void Payment");
    public static final TransactionType BALANCE = new TransactionType("BALANCE", "Balance");
    public static final TransactionType REVERSEAUTHORIZE = new TransactionType("REVERSEAUTHORIZE", "Reverse Authorize");
    private String type;
    private String friendlyType;

    public static TransactionType getInstance(String type) {
        return TYPES.get(type);
    }

    public TransactionType() {
    }

    public TransactionType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionType other = (TransactionType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

