/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.StateDao;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.State;
import org.springframework.stereotype.Repository;

@Repository(value="blStateDao")
public class StateDaoImpl
implements StateDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public State findStateByAbbreviation(String abbreviation) {
        return (State)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.State"), (Object)abbreviation);
    }

    @Override
    public List<State> findStates() {
        Query query = this.em.createNamedQuery("BC_FIND_STATES");
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public List<State> findStates(String countryAbbreviation) {
        Query query = this.em.createNamedQuery("BC_FIND_STATES_BY_COUNTRY_ABBREVIATION");
        query.setParameter("countryAbbreviation", (Object)countryAbbreviation);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    public Country findCountryByShortName(String shortName) {
        return (Country)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.Country"), (Object)shortName);
    }

    public List<Country> findCountries() {
        Query query = this.em.createNamedQuery("BC_FIND_COUNTRIES");
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public State create() {
        return (State)this.entityConfiguration.createEntityInstance(State.class.getName());
    }

    @Override
    public State save(State state) {
        return (State)this.em.merge((Object)state);
    }
}

