/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.email.service;

import java.util.HashMap;
import javax.annotation.Resource;
import org.broadleafcommerce.common.email.dao.EmailReportingDao;
import org.broadleafcommerce.common.email.domain.EmailTarget;
import org.broadleafcommerce.common.email.service.EmailService;
import org.broadleafcommerce.common.email.service.EmailTrackingManager;
import org.broadleafcommerce.common.email.service.exception.EmailException;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.email.service.info.NullEmailInfo;
import org.broadleafcommerce.common.email.service.info.ServerInfo;
import org.broadleafcommerce.common.email.service.message.EmailPropertyType;
import org.broadleafcommerce.common.email.service.message.EmailServiceProducer;
import org.broadleafcommerce.common.email.service.message.MessageCreator;
import org.springframework.stereotype.Service;

@Service(value="blEmailService")
public class EmailServiceImpl
implements EmailService {
    @Resource(name="blEmailTrackingManager")
    protected EmailTrackingManager emailTrackingManager;
    @Resource(name="blServerInfo")
    protected ServerInfo serverInfo;
    protected EmailServiceProducer emailServiceProducer;
    @Resource(name="blMessageCreator")
    protected MessageCreator messageCreator;
    @Resource(name="blEmailReportingDao")
    protected EmailReportingDao emailReportingDao;

    @Override
    public boolean sendTemplateEmail(EmailTarget emailTarget, EmailInfo emailInfo, HashMap<String, Object> props) {
        if (props == null) {
            props = new HashMap();
        }
        if (emailInfo == null) {
            emailInfo = new EmailInfo();
        }
        props.put(EmailPropertyType.INFO.getType(), emailInfo);
        props.put(EmailPropertyType.USER.getType(), emailTarget);
        Long emailId = this.emailTrackingManager.createTrackedEmail(emailTarget.getEmailAddress(), emailInfo.getEmailType(), null);
        props.put("emailTrackingId", emailId);
        return this.sendBasicEmail(emailInfo, emailTarget, props);
    }

    @Override
    public boolean sendTemplateEmail(String emailAddress, EmailInfo emailInfo, HashMap<String, Object> props) {
        if (!(emailInfo instanceof NullEmailInfo)) {
            EmailTarget emailTarget = this.emailReportingDao.createTarget();
            emailTarget.setEmailAddress(emailAddress);
            return this.sendTemplateEmail(emailTarget, emailInfo, props);
        }
        return true;
    }

    @Override
    public boolean sendBasicEmail(EmailInfo emailInfo, EmailTarget emailTarget, HashMap<String, Object> props) {
        if (props == null) {
            props = new HashMap();
        }
        if (emailInfo == null) {
            emailInfo = new EmailInfo();
        }
        props.put(EmailPropertyType.INFO.getType(), emailInfo);
        props.put(EmailPropertyType.USER.getType(), emailTarget);
        if (Boolean.parseBoolean(emailInfo.getSendEmailReliableAsync())) {
            if (this.emailServiceProducer == null) {
                throw new EmailException("The property sendEmailReliableAsync on EmailInfo is true, but the EmailService does not have an instance of JMSEmailServiceProducer set.");
            }
            this.emailServiceProducer.send(props);
        } else {
            this.messageCreator.sendMessage(props);
        }
        return true;
    }

    public EmailTrackingManager getEmailTrackingManager() {
        return this.emailTrackingManager;
    }

    public void setEmailTrackingManager(EmailTrackingManager emailTrackingManager) {
        this.emailTrackingManager = emailTrackingManager;
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public EmailServiceProducer getEmailServiceProducer() {
        return this.emailServiceProducer;
    }

    public void setEmailServiceProducer(EmailServiceProducer emailServiceProducer) {
        this.emailServiceProducer = emailServiceProducer;
    }

    public MessageCreator getMessageCreator() {
        return this.messageCreator;
    }

    public void setMessageCreator(MessageCreator messageCreator) {
        this.messageCreator = messageCreator;
    }
}

