/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.email.service.message;

import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.velocity.app.VelocityEngine;
import org.broadleafcommerce.common.email.domain.EmailTarget;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.email.service.message.Attachment;
import org.broadleafcommerce.common.email.service.message.EmailPropertyType;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.ui.velocity.VelocityEngineUtils;

public class MessageCreator {
    private VelocityEngine velocityEngine;
    private JavaMailSender mailSender;
    private HashMap<String, Object> additionalConfigItems;

    public MessageCreator(VelocityEngine velocityEngine, JavaMailSender mailSender, HashMap<String, Object> additionalConfigItems) {
        this.velocityEngine = velocityEngine;
        this.mailSender = mailSender;
        this.additionalConfigItems = additionalConfigItems;
    }

    public void sendMessage(final HashMap props) throws MailException {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                String text;
                String messageBody;
                EmailTarget emailUser = (EmailTarget)props.get(EmailPropertyType.USER.getType());
                EmailInfo info = (EmailInfo)props.get(EmailPropertyType.INFO.getType());
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage, info.getAttachments() != null && info.getAttachments().size() > 0);
                message.setTo(emailUser.getEmailAddress());
                message.setFrom(info.getFromAddress());
                message.setSubject(info.getSubject());
                if (emailUser.getBCCAddresses() != null && emailUser.getBCCAddresses().length > 0) {
                    message.setBcc(emailUser.getBCCAddresses());
                }
                if (emailUser.getCCAddresses() != null && emailUser.getCCAddresses().length > 0) {
                    message.setCc(emailUser.getCCAddresses());
                }
                if ((messageBody = info.getMessageBody()) == null) {
                    HashMap copy = (HashMap)props.clone();
                    if (MessageCreator.this.additionalConfigItems != null) {
                        copy.putAll(MessageCreator.this.additionalConfigItems);
                    }
                    text = VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)MessageCreator.this.velocityEngine, (String)info.getEmailTemplate(), (Map)copy);
                } else {
                    text = messageBody;
                }
                message.setText(text, true);
                for (Attachment attachment : info.getAttachments()) {
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(attachment.getData(), attachment.getMimeType());
                    message.addAttachment(attachment.getFilename(), (DataSource)dataSource);
                }
            }
        };
        this.mailSender.send(preparator);
    }
}

