/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.extensibility.context;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardConfigLocations {
    private static final Log LOG = LogFactory.getLog(StandardConfigLocations.class);
    public static final String EXTRACONFIGLOCATIONSKEY = "extra.config.locations";
    public static final int ALLCONTEXTTYPE = 0;
    public static final int WEBCONTEXTTYPE = 1;
    public static final int SERVICECONTEXTTYPE = 2;
    public static final int TESTCONTEXTTYPE = 3;
    public static final int APPCONTEXTTYPE = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] retrieveAll(int contextType) throws IOException {
        String[] response;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(StandardConfigLocations.class.getResourceAsStream("StandardConfigLocations.txt")));
            ArrayList<String> items = new ArrayList<String>();
            boolean eof = false;
            while (!eof) {
                String temp = reader.readLine();
                if (temp == null) {
                    eof = true;
                    continue;
                }
                StandardConfigLocations.addContextFile(contextType, items, temp);
            }
            String extraConfigFiles = System.getProperty(EXTRACONFIGLOCATIONSKEY);
            if (extraConfigFiles != null) {
                String[] files;
                for (String file : files = extraConfigFiles.split(" ")) {
                    StandardConfigLocations.addContextFile(contextType, items, file);
                }
            }
            response = new String[]{};
            response = items.toArray(response);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return response;
    }

    private static void addContextFile(int contextType, ArrayList<String> items, String temp) {
        if (!(temp.startsWith("#") || temp.trim().length() <= 0 || StandardConfigLocations.class.getClassLoader().getResource(temp.trim()) == null || contextType != 0 && (contextType != 1 && contextType != 4 || temp.indexOf("-web-") < 0) && (contextType != 2 && contextType != 3 && contextType != 4 || temp.indexOf("-web-") >= 0 || temp.indexOf("-test") >= 0 || temp.indexOf("-admin-") >= 0) && (contextType != 2 && contextType != 3 && contextType != 4 || temp.indexOf("-admin-applicationContext-persistence") < 0) && (contextType != 3 || temp.indexOf("-test") < 0 && temp.indexOf("-admin-") < 0))) {
            items.add(temp.trim());
        }
    }
}

