/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.locale.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.locale.dao.LocaleDao;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blLocaleDao")
public class LocaleDaoImpl
implements LocaleDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Locale findLocaleByCode(String localeCode) {
        Query query = this.em.createNamedQuery("BC_READ_LOCALE_BY_CODE");
        query.setParameter("localeCode", (Object)localeCode);
        List localeList = query.getResultList();
        if (localeList.size() >= 1) {
            return (Locale)localeList.get(0);
        }
        return null;
    }

    @Override
    public Locale findDefaultLocale() {
        Query query = this.em.createNamedQuery("BC_READ_DEFAULT_LOCALE");
        List localeList = query.getResultList();
        if (localeList.size() >= 1) {
            return (Locale)localeList.get(0);
        }
        return null;
    }

    @Override
    public List<Locale> findAllLocales() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_LOCALES");
        return query.getResultList();
    }
}

