/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.persistence;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.type.Type;

public class IdOverrideTableGenerator
extends TableGenerator {
    public static final String ENTITY_NAME_PARAM = "entity_name";
    private String entityName;

    public Serializable generate(SessionImplementor session, Object obj) {
        Serializable id = session.getEntityPersister(this.entityName, obj).getIdentifier(obj, session);
        if (id != null) {
            return id;
        }
        return super.generate(session, obj);
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        super.configure(type, params, dialect);
        this.entityName = (String)params.get(ENTITY_NAME_PARAM);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}

