/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.time;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class DayOfWeekType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, DayOfWeekType> TYPES = new HashMap<String, DayOfWeekType>();
    public static final DayOfWeekType SUNDAY = new DayOfWeekType("1", "Sunday");
    public static final DayOfWeekType MONDAY = new DayOfWeekType("2", "Monday");
    public static final DayOfWeekType TUESDAY = new DayOfWeekType("3", "Tuesday");
    public static final DayOfWeekType WEDNESDAY = new DayOfWeekType("4", "Wednesday");
    public static final DayOfWeekType THURSDAY = new DayOfWeekType("5", "Thursday");
    public static final DayOfWeekType FRIDAY = new DayOfWeekType("6", "Friday");
    public static final DayOfWeekType SATURDAY = new DayOfWeekType("7", "Saturday");
    private String type;
    private String friendlyType;

    public static DayOfWeekType getInstance(String type) {
        return TYPES.get(type);
    }

    public DayOfWeekType() {
    }

    public DayOfWeekType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + DayOfWeekType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DayOfWeekType other = (DayOfWeekType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

