/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.time;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.broadleafcommerce.common.time.DefaultTimeSource;
import org.broadleafcommerce.common.time.TimeSource;

public class SystemTime {
    private static final TimeSource defaultTimeSource = new DefaultTimeSource();
    private static TimeSource globalTimeSource = null;
    private static final InheritableThreadLocal<TimeSource> localTimeSource = new InheritableThreadLocal();

    private static TimeSource getTimeSource() {
        TimeSource localTS = (TimeSource)localTimeSource.get();
        TimeSource applicableTimeSource = localTS != null ? localTS : (globalTimeSource != null ? globalTimeSource : defaultTimeSource);
        return applicableTimeSource;
    }

    public static void setGlobalTimeSource(TimeSource globalTS) {
        globalTimeSource = globalTS;
    }

    public static void resetGlobalTimeSource() {
        SystemTime.setGlobalTimeSource(null);
    }

    public static void setLocalTimeSource(TimeSource localTS) {
        localTimeSource.set(localTS);
    }

    public static void resetLocalTimeSource() {
        localTimeSource.remove();
    }

    public static void reset() {
        SystemTime.resetGlobalTimeSource();
        SystemTime.resetLocalTimeSource();
    }

    public static long asMillis() {
        return SystemTime.asMillis(true);
    }

    public static long asMillis(boolean includeTime) {
        if (includeTime) {
            return SystemTime.getTimeSource().timeInMillis();
        }
        return SystemTime.asCalendar(includeTime).getTimeInMillis();
    }

    public static Date asDate() {
        return SystemTime.asDate(true);
    }

    public static Date asDate(boolean includeTime) {
        if (includeTime) {
            return new Date(SystemTime.asMillis());
        }
        return SystemTime.asCalendar(includeTime).getTime();
    }

    public static Calendar asCalendar() {
        return SystemTime.asCalendar(true);
    }

    public static Calendar asCalendar(boolean includeTime) {
        return SystemTime.asCalendar(Locale.getDefault(), TimeZone.getDefault(), includeTime);
    }

    public static Calendar asCalendar(Locale locale) {
        return SystemTime.asCalendar(locale, TimeZone.getDefault(), true);
    }

    public static Calendar asCalendar(TimeZone timeZone) {
        return SystemTime.asCalendar(Locale.getDefault(), timeZone, true);
    }

    public static Calendar asCalendar(Locale locale, TimeZone timeZone, boolean includeTime) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        calendar.setTimeInMillis(SystemTime.asMillis());
        if (!includeTime) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar;
    }
}

