/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.vendor.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractVendorService {
    private static final Log LOG = LogFactory.getLog(AbstractVendorService.class);
    private static final String POST_METHOD = "POST";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream postMessage(Map<String, String> content, URL destination, String encodeCharset) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)destination.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod(POST_METHOD);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(connection.getOutputStream());
            boolean isFirst = true;
            for (String key : content.keySet()) {
                if (!isFirst) {
                    osw.write("&");
                }
                isFirst = false;
                String value = content.get(key);
                osw.write(URLEncoder.encode(key, encodeCharset));
                osw.write("=");
                osw.write(URLEncoder.encode(value, encodeCharset));
            }
            osw.flush();
            osw.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Problem closing the OuputStream to destination: " + destination.toExternalForm()), (Throwable)e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (Throwable e) {}
            }
        }
        return new BufferedInputStream(connection.getInputStream());
    }
}

