/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.springframework.stereotype.Repository;

@Repository(value="blSkuDao")
public class SkuDaoImpl
implements SkuDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Sku save(Sku sku) {
        return (Sku)this.em.merge((Object)sku);
    }

    @Override
    public Sku readSkuById(Long skuId) {
        return (Sku)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.catalog.domain.Sku"), (Object)skuId);
    }

    @Override
    public Sku readFirstSku() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_FIRST_SKU", Sku.class);
        return (Sku)query.getSingleResult();
    }

    @Override
    public List<Sku> readAllSkus() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SKUS", Sku.class);
        return query.getResultList();
    }

    @Override
    public List<Sku> readSkusById(List<Long> ids) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_SKUS_BY_ID", Sku.class);
        query.setParameter("skuIds", ids);
        return query.getResultList();
    }

    @Override
    public void delete(Sku sku) {
        if (!this.em.contains((Object)sku)) {
            sku = this.readSkuById(sku.getId());
        }
        this.em.remove((Object)sku);
    }

    @Override
    public Sku create() {
        return (Sku)this.entityConfiguration.createEntityInstance(Sku.class.getName());
    }
}

