/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SHIPPING_RATE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class ShippingRateImpl
implements ShippingRate {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ShippingRateId", strategy=GenerationType.TABLE)
    @TableGenerator(name="ShippingRateId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="ShippingRateImpl", allocationSize=50)
    @Column(name="ID")
    protected Long id;
    @Column(name="FEE_TYPE", nullable=false)
    @Index(name="SHIPPINGRATE_FEE_INDEX", columnNames={"FEE_TYPE"})
    protected String feeType;
    @Column(name="FEE_SUB_TYPE")
    @Index(name="SHIPPINGRATE_FEESUB_INDEX", columnNames={"FEE_SUB_TYPE"})
    protected String feeSubType;
    @Column(name="FEE_BAND", nullable=false)
    protected Integer feeBand;
    @Column(name="BAND_UNIT_QTY", nullable=false)
    protected BigDecimal bandUnitQuantity;
    @Column(name="BAND_RESULT_QTY", nullable=false)
    protected BigDecimal bandResultQuantity;
    @Column(name="BAND_RESULT_PCT", nullable=false)
    protected Integer bandResultPercent;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getFeeType() {
        return this.feeType;
    }

    @Override
    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    @Override
    public String getFeeSubType() {
        return this.feeSubType;
    }

    @Override
    public void setFeeSubType(String feeSubType) {
        this.feeSubType = feeSubType;
    }

    @Override
    public Integer getFeeBand() {
        return this.feeBand;
    }

    @Override
    public void setFeeBand(Integer feeBand) {
        this.feeBand = feeBand;
    }

    @Override
    public BigDecimal getBandUnitQuantity() {
        return this.bandUnitQuantity;
    }

    @Override
    public void setBandUnitQuantity(BigDecimal bandUnitQuantity) {
        this.bandUnitQuantity = bandUnitQuantity;
    }

    @Override
    public BigDecimal getBandResultQuantity() {
        return this.bandResultQuantity;
    }

    @Override
    public void setBandResultQuantity(BigDecimal bandResultQuantity) {
        this.bandResultQuantity = bandResultQuantity;
    }

    @Override
    public Integer getBandResultPercent() {
        return this.bandResultPercent;
    }

    @Override
    public void setBandResultPercent(Integer bandResultPercent) {
        this.bandResultPercent = bandResultPercent;
    }

    public String toString() {
        return this.getFeeSubType() + " " + this.getBandResultQuantity() + " " + this.getBandResultPercent();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bandResultPercent == null ? 0 : this.bandResultPercent.hashCode());
        result = 31 * result + (this.bandResultQuantity == null ? 0 : this.bandResultQuantity.hashCode());
        result = 31 * result + (this.bandUnitQuantity == null ? 0 : this.bandUnitQuantity.hashCode());
        result = 31 * result + (this.feeBand == null ? 0 : this.feeBand.hashCode());
        result = 31 * result + (this.feeSubType == null ? 0 : this.feeSubType.hashCode());
        result = 31 * result + (this.feeType == null ? 0 : this.feeType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShippingRateImpl other = (ShippingRateImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.bandResultPercent == null ? other.bandResultPercent != null : !this.bandResultPercent.equals(other.bandResultPercent)) {
            return false;
        }
        if (this.bandResultQuantity == null ? other.bandResultQuantity != null : !this.bandResultQuantity.equals(other.bandResultQuantity)) {
            return false;
        }
        if (this.bandUnitQuantity == null ? other.bandUnitQuantity != null : !this.bandUnitQuantity.equals(other.bandUnitQuantity)) {
            return false;
        }
        if (this.feeBand == null ? other.feeBand != null : !this.feeBand.equals(other.feeBand)) {
            return false;
        }
        if (this.feeSubType == null ? other.feeSubType != null : !this.feeSubType.equals(other.feeSubType)) {
            return false;
        }
        return !(this.feeType == null ? other.feeType != null : !this.feeType.equals(other.feeType));
    }
}

