/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerDao")
public class CustomerDaoImpl
implements CustomerDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Customer readCustomerById(Long id) {
        return (Customer)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.Customer"), (Object)id);
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_USER_NAME");
        query.setParameter("username", (Object)username);
        List customers = query.getResultList();
        return customers == null || customers.isEmpty() ? null : (Customer)customers.get(0);
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_EMAIL");
        query.setParameter("email", (Object)emailAddress);
        List customers = query.getResultList();
        return customers == null || customers.isEmpty() ? null : (Customer)customers.get(0);
    }

    @Override
    public Customer save(Customer customer) {
        if (customer.getAuditable() != null) {
            // empty if block
        }
        return (Customer)this.em.merge((Object)customer);
    }

    @Override
    public Customer create() {
        Customer customer = (Customer)this.entityConfiguration.createEntityInstance(Customer.class.getName());
        return customer;
    }
}

