/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.web.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.GenericValidator;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.broadleafcommerce.profile.web.controller.validator.CustomerPhoneValidator;
import org.broadleafcommerce.profile.web.controller.validator.PhoneValidator;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.model.PhoneNameForm;
import org.broadleafcommerce.profile.web.core.util.PhoneFormatter;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="blCustomerPhoneController")
@RequestMapping(value={"/myaccount/phone"})
public class CustomerPhoneController {
    private static final String prefix = "myAccount/phone/customerPhones";
    private static final String redirect = "redirect:/myaccount/phone/viewPhone.htm";
    @Resource(name="blCustomerPhoneService")
    private CustomerPhoneService customerPhoneService;
    @Resource(name="blCustomerPhoneValidator")
    private CustomerPhoneValidator customerPhoneValidator;
    @Resource(name="blCustomerState")
    private CustomerState customerState;
    @Resource(name="blEntityConfiguration")
    private EntityConfiguration entityConfiguration;
    @Resource(name="blPhoneFormatter")
    private PhoneFormatter phoneFormatter;
    @Resource(name="blPhoneValidator")
    private PhoneValidator phoneValidator;
    private String deletePhoneSuccessView = "redirect:/myaccount/phone/viewPhone.htm";
    private String makePhoneDefaultSuccessView = "redirect:/myaccount/phone/viewPhone.htm";
    private String savePhoneErrorView = "myAccount/phone/customerPhones";
    private String savePhoneSuccessView = "myAccount/phone/customerPhones";
    private String viewPhoneErrorView = "myAccount/phone/customerPhones";
    private String viewPhoneSuccessView = "myAccount/phone/customerPhones";

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String deletePhone(@RequestParam(required=true) Long customerPhoneId, HttpServletRequest request) {
        this.customerPhoneService.deleteCustomerPhoneById(customerPhoneId);
        request.setAttribute("phone.deletedPhone", (Object)"true");
        return this.deletePhoneSuccessView + customerPhoneId;
    }

    @ModelAttribute(value="phoneNameForm")
    public PhoneNameForm initPhoneNameForm(HttpServletRequest request, Model model) {
        PhoneNameForm form = new PhoneNameForm();
        form.setPhone((Phone)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.core.domain.Phone"));
        return form;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String makePhoneDefault(@RequestParam(required=true) Long customerPhoneId, HttpServletRequest request) {
        CustomerPhone customerPhone = this.customerPhoneService.readCustomerPhoneById(customerPhoneId);
        this.customerPhoneService.makeCustomerPhoneDefault(customerPhone.getId(), customerPhone.getCustomer().getId());
        request.setAttribute("phone.madePhoneDefault", (Object)"true");
        return this.makePhoneDefaultSuccessView;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String savePhone(@ModelAttribute(value="phoneNameForm") PhoneNameForm phoneNameForm, BindingResult errors, HttpServletRequest request, @RequestParam(required=false) Long customerPhoneId, @RequestParam(required=false) Long phoneId) {
        if (GenericValidator.isBlankOrNull((String)phoneNameForm.getPhoneName())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"phoneName", (String)"phoneName.required");
        }
        if (phoneId != null) {
            phoneNameForm.getPhone().setId(phoneId);
        }
        this.phoneFormatter.formatPhoneNumber(phoneNameForm.getPhone());
        errors.pushNestedPath("phone");
        this.phoneValidator.validate(phoneNameForm.getPhone(), (Errors)errors);
        errors.popNestedPath();
        if (!errors.hasErrors()) {
            CustomerPhone customerPhone = (CustomerPhone)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.core.domain.CustomerPhone");
            customerPhone.setCustomer(this.customerState.getCustomer(request));
            customerPhone.setPhoneName(phoneNameForm.getPhoneName());
            customerPhone.setPhone(phoneNameForm.getPhone());
            if (customerPhoneId != null && customerPhoneId > 0L) {
                customerPhone.setId(customerPhoneId);
            }
            this.customerPhoneValidator.validate(customerPhone, (Errors)errors);
            if (!errors.hasErrors()) {
                customerPhone = this.customerPhoneService.saveCustomerPhone(customerPhone);
                request.setAttribute("customerPhoneId", (Object)customerPhone.getId());
                request.setAttribute("phoneId", (Object)customerPhone.getPhone().getId());
            }
            return this.savePhoneSuccessView;
        }
        return this.savePhoneErrorView;
    }

    public void setCustomerPhoneService(CustomerPhoneService customerPhoneService) {
        this.customerPhoneService = customerPhoneService;
    }

    public void setCustomerPhoneValidator(CustomerPhoneValidator customerPhoneValidator) {
        this.customerPhoneValidator = customerPhoneValidator;
    }

    public void setCustomerState(CustomerState customerState) {
        this.customerState = customerState;
    }

    public void setdeletePhoneSuccessView(String deletePhoneSuccessView) {
        this.deletePhoneSuccessView = deletePhoneSuccessView;
    }

    public void setEntityConfiguration(EntityConfiguration entityConfiguration) {
        this.entityConfiguration = entityConfiguration;
    }

    public void setmakePhoneDefaultSuccessView(String makePhoneDefaultSuccessView) {
        this.makePhoneDefaultSuccessView = makePhoneDefaultSuccessView;
    }

    public void setPhoneFormatter(PhoneFormatter phoneFormatter) {
        this.phoneFormatter = phoneFormatter;
    }

    public void setPhoneValidator(PhoneValidator phoneValidator) {
        this.phoneValidator = phoneValidator;
    }

    public void setsavePhoneErrorView(String savePhoneErrorView) {
        this.savePhoneErrorView = savePhoneErrorView;
    }

    public void setsavePhoneSuccessView(String savePhoneSuccessView) {
        this.savePhoneSuccessView = savePhoneSuccessView;
    }

    public void setviewPhoneErrorView(String viewPhoneErrorView) {
        this.viewPhoneErrorView = viewPhoneErrorView;
    }

    public void setviewPhoneSuccessView(String viewPhoneSuccessView) {
        this.viewPhoneSuccessView = viewPhoneSuccessView;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST})
    public String viewPhone(@RequestParam(required=false) Long customerPhoneId, HttpServletRequest request, @ModelAttribute(value="phoneNameForm") PhoneNameForm phoneNameForm, BindingResult errors) {
        if (customerPhoneId == null) {
            return this.viewPhoneSuccessView;
        }
        Long currCustomerId = this.customerState.getCustomer(request).getId();
        CustomerPhone cPhone = this.customerPhoneService.readCustomerPhoneById(customerPhoneId);
        if (cPhone != null) {
            if (!cPhone.getCustomer().getId().equals(currCustomerId)) {
                return this.viewPhoneErrorView;
            }
            phoneNameForm.setPhone(cPhone.getPhone());
            phoneNameForm.setPhoneName(cPhone.getPhoneName());
            request.setAttribute("customerPhoneId", (Object)cPhone.getId());
            request.setAttribute("phoneId", (Object)cPhone.getPhone().getId());
            return this.viewPhoneSuccessView;
        }
        return this.viewPhoneErrorView;
    }
}

