/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.legacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.common.encryption.EncryptionModule;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.SecurePaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class LegacyCheckoutTest
extends BaseTest {
    @Resource(name="blCheckoutService")
    private CheckoutService checkoutService;
    @Resource(name="blEncryptionModule")
    private EncryptionModule encryptionModule;
    @Resource
    private CustomerService customerService;
    @Resource(name="blOrderService")
    private OrderService orderService;
    @Resource
    private CatalogService catalogService;
    @Resource(name="blOrderItemService")
    private OrderItemService orderItemService;
    @Resource
    private SecurePaymentInfoService securePaymentInfoService;

    @Test(groups={"checkoutLegacy"}, dependsOnGroups={"createCartForCustomerLegacy", "testShippingInsertLegacy"})
    @Transactional
    public void testCheckout() throws Exception {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.orderService.createNewCartForCustomer(customer);
        Address address = this.buildAddress();
        FulfillmentGroup group = this.buildFulfillmentGroup(order, address);
        this.addSampleItemToOrder(order, group);
        order.setTotalShipping(new Money(0.0));
        Map<PaymentInfo, Referenced> map = this.addPaymentToOrder(order, address);
        CheckoutResponse response = this.checkoutService.performCheckout(order, map);
        for (PaymentInfo paymentInfo : response.getInfos().keySet()) {
            assert (paymentInfo.getReferenceNumber().equals("abc123"));
            assert (((Referenced)response.getInfos().get(paymentInfo)).getReferenceNumber().equals("abc123"));
        }
        Referenced referenced = null;
        try {
            referenced = this.securePaymentInfoService.findSecurePaymentInfo("abc123", PaymentInfoType.CREDIT_CARD);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            referenced = this.securePaymentInfoService.findSecurePaymentInfo("1234", PaymentInfoType.CREDIT_CARD);
        }
        catch (Exception e) {
            // empty catch block
        }
        assert (referenced == null);
        assert (order.getTotal().greaterThan(order.getSubTotal()));
        assert (response.getPaymentResponse().getResponseItems().size() > 0);
    }

    private Map<PaymentInfo, Referenced> addPaymentToOrder(Order order, Address address) {
        PaymentInfoImpl payment = new PaymentInfoImpl();
        payment.setAddress(address);
        payment.setAmount(new Money(15.75));
        payment.setReferenceNumber("1234");
        payment.setType(PaymentInfoType.CREDIT_CARD);
        payment.setOrder(order);
        CreditCardPaymentInfo cc = new CreditCardPaymentInfo(){
            private static final long serialVersionUID = 1L;
            private String referenceNumber = "1234";

            public String getCvvCode() {
                return "123";
            }

            public Integer getExpirationMonth() {
                return 11;
            }

            public Integer getExpirationYear() {
                return 2011;
            }

            public Long getId() {
                return null;
            }

            public String getPan() {
                return "1111111111111111";
            }

            public String getNameOnCard() {
                return "Cardholder Name";
            }

            public void setCvvCode(String cvvCode) {
            }

            public void setExpirationMonth(Integer expirationMonth) {
            }

            public void setExpirationYear(Integer expirationYear) {
            }

            public void setId(Long id) {
            }

            public void setNameOnCard(String nameOnCard) {
            }

            public void setPan(String pan) {
            }

            public EncryptionModule getEncryptionModule() {
                return LegacyCheckoutTest.this.encryptionModule;
            }

            public String getReferenceNumber() {
                return this.referenceNumber;
            }

            public void setEncryptionModule(EncryptionModule encryptionModule) {
            }

            public void setReferenceNumber(String referenceNumber) {
                this.referenceNumber = referenceNumber;
            }
        };
        HashMap<PaymentInfo, Referenced> map = new HashMap<PaymentInfo, Referenced>();
        map.put((PaymentInfo)payment, (Referenced)cc);
        return map;
    }

    private void addSampleItemToOrder(Order order, FulfillmentGroup group) {
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        item.setOrder(order);
        item.setPrice(new Money(14.99));
        item.setRetailPrice(new Money(14.99));
        item.setQuantity(1);
        SkuImpl newSku = new SkuImpl();
        newSku.setName("Under Armor T-Shirt -- Red");
        newSku.setRetailPrice(new Money(14.99));
        newSku.setActiveStartDate(SystemTime.asDate());
        newSku.setDiscountable(Boolean.valueOf(false));
        newSku = this.catalogService.saveSku((Sku)newSku);
        item.setSku((Sku)newSku);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        ArrayList<DiscreteOrderItemImpl> items = new ArrayList<DiscreteOrderItemImpl>();
        items.add(item);
        order.setOrderItems(items);
        FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
        fgItem.setFulfillmentGroup(group);
        fgItem.setOrderItem((OrderItem)item);
        fgItem.setQuantity(1);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem);
    }

    private FulfillmentGroup buildFulfillmentGroup(Order order, Address address) {
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setIsShippingPriceTaxable(Boolean.valueOf(true));
        group.setOrder(order);
        group.setAddress(address);
        ArrayList<FulfillmentGroupImpl> groups = new ArrayList<FulfillmentGroupImpl>();
        groups.add(group);
        order.setFulfillmentGroups(groups);
        Money total = new Money(5.0);
        group.setShippingPrice(total);
        group.setMethod("standard");
        group.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        return group;
    }

    private Address buildAddress() {
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Test Rd");
        address.setCity("Dallas");
        address.setFirstName("Jeff");
        address.setLastName("Fischer");
        address.setPostalCode("75240");
        address.setPrimaryPhone("972-978-9067");
        StateImpl state = new StateImpl();
        state.setAbbreviation("ALL");
        state.setName("ALL");
        address.setState((State)state);
        CountryImpl country = new CountryImpl();
        country.setAbbreviation("US");
        country.setName("United States");
        state.setCountry((Country)country);
        address.setCountry((Country)country);
        return address;
    }
}

