/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.legacy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.order.FulfillmentGroupDataProvider;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.call.BundleOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.DiscreteOrderItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.legacy.LegacyOrderBaseTest;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.PaymentInfoDataProvider;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.pricing.ShippingRateDataProvider;
import org.broadleafcommerce.core.pricing.domain.ShippingRate;
import org.broadleafcommerce.core.pricing.service.ShippingRateService;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.pricing.service.workflow.type.ShippingServiceType;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class LegacyOrderTest
extends LegacyOrderBaseTest {
    private Long orderId = null;
    private int numOrderItems = 0;
    private Long fulfillmentGroupId;
    private Long bundleOrderItemId;
    @Resource(name="blOrderItemService")
    private OrderItemService orderItemService;
    @Resource
    private SkuDao skuDao;
    @Resource
    private ShippingRateService shippingRateService;

    @Test(groups={"createCartForCustomerLegacy"}, dependsOnGroups={"readCustomer", "createPhone"})
    @Transactional
    @Rollback(value=false)
    public void createCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.cartService.createNewCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"findCurrentCartForCustomerLegacy"}, dependsOnGroups={"readCustomer", "createPhone", "createCartForCustomerLegacy"})
    @Transactional
    @Rollback(value=false)
    public void findCurrentCartForCustomer() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Order order = this.cartService.findCartForCustomer(customer);
        assert (order != null);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"addItemToOrderLegacy"}, dependsOnGroups={"findCurrentCartForCustomerLegacy", "createSku", "testCatalog"})
    @Rollback(value=false)
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void addItemToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.cartService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        DiscreteOrderItem item = (DiscreteOrderItem)this.cartService.addDiscreteItemToOrder(order, itemRequest);
        assert (item != null);
        assert (item.getQuantity() == this.numOrderItems);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
    }

    @Test(groups={"addAnotherItemToOrderLegacy"}, dependsOnGroups={"addItemToOrderLegacy"})
    @Rollback(value=false)
    @Transactional
    public void addAnotherItemToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.cartService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        this.cartService.setAutomaticallyMergeLikeItems(true);
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        DiscreteOrderItem item = (DiscreteOrderItem)this.cartService.addDiscreteItemToOrder(order, itemRequest, true);
        assert (item.getSku() != null);
        assert (item.getSku().equals(sku));
        assert (item.getQuantity() == 2);
        order = this.cartService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 1);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 2);
        this.cartService.setAutomaticallyMergeLikeItems(false);
        DiscreteOrderItemRequest itemRequest2 = new DiscreteOrderItemRequest();
        itemRequest2.setQuantity(1);
        itemRequest2.setSku(sku);
        DiscreteOrderItem item2 = (DiscreteOrderItem)this.cartService.addDiscreteItemToOrder(order, itemRequest2, true);
        assert (item2.getSku() != null);
        assert (item2.getSku().equals(sku));
        assert (item2.getQuantity() == 1);
        order = this.cartService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 2);
        assert (((OrderItem)order.getOrderItems().get(1)).getQuantity() == 1);
    }

    @Test(groups={"addBundleToOrderLegacy"}, dependsOnGroups={"addAnotherItemToOrderLegacy"})
    @Rollback(value=false)
    @Transactional
    public void addBundleToOrder() throws PricingException {
        ++this.numOrderItems;
        Sku sku = this.skuDao.readFirstSku();
        Order order = this.cartService.findOrderById(this.orderId);
        assert (order != null);
        assert (sku.getId() != null);
        BundleOrderItemRequest bundleRequest = new BundleOrderItemRequest();
        bundleRequest.setQuantity(1);
        bundleRequest.setName("myBundle");
        DiscreteOrderItemRequest itemRequest = new DiscreteOrderItemRequest();
        itemRequest.setQuantity(1);
        itemRequest.setSku(sku);
        bundleRequest.getDiscreteOrderItems().add(itemRequest);
        BundleOrderItem item = (BundleOrderItem)this.cartService.addBundleItemToOrder(order, bundleRequest);
        this.bundleOrderItemId = item.getId();
        assert (item != null);
        assert (item.getQuantity() == 1);
    }

    @Test(groups={"removeBundleFromOrderLegacy"}, dependsOnGroups={"addBundleToOrderLegacy"})
    @Rollback(value=false)
    @Transactional
    public void removeBundleFromOrder() throws PricingException {
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() == this.numOrderItems);
        int startingSize = orderItems.size();
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem != null);
        assert (bundleOrderItem.getDiscreteOrderItems() != null);
        assert (bundleOrderItem.getDiscreteOrderItems().size() == 1);
        this.cartService.removeItemFromOrder(order, (OrderItem)bundleOrderItem);
        order = this.cartService.findOrderById(this.orderId);
        List items = order.getOrderItems();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"getItemsForOrderLegacy"}, dependsOnGroups={"removeBundleFromOrderLegacy"})
    @Transactional
    public void getItemsForOrder() {
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems != null);
        assert (orderItems.size() == this.numOrderItems - 1);
    }

    @Test(groups={"updateItemsInOrderLegacy"}, dependsOnGroups={"getItemsForOrderLegacy"})
    @Transactional
    public void updateItemsInOrder() throws ItemNotFoundException, PricingException {
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        ((DiscreteOrderItem)item).getSku().setSalePrice(new Money(BigDecimal.valueOf(10000L)));
        ((DiscreteOrderItem)item).getSku().setRetailPrice(new Money(BigDecimal.valueOf(10000L)));
        item.setQuantity(10);
        this.cartService.updateItemQuantity(order, item);
        OrderItem updatedItem = this.orderItemService.readOrderItemById(item.getId());
        assert (updatedItem != null);
        assert (updatedItem.getPrice().equals((Object)new Money(BigDecimal.valueOf(10000L))));
        assert (updatedItem.getQuantity() == 10);
        ArrayList updateItems = new ArrayList(order.getOrderItems());
        ((OrderItem)updateItems.get(0)).setQuantity(15);
        this.cartService.updateItemQuantity(order, updatedItem);
        order = this.cartService.findOrderById(this.orderId);
        assert (((OrderItem)order.getOrderItems().get(0)).getQuantity() == 15);
    }

    @Test(groups={"removeItemFromOrderLegacy"}, dependsOnGroups={"getItemsForOrderLegacy"})
    @Transactional
    public void removeItemFromOrder() throws PricingException {
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        int startingSize = orderItems.size();
        OrderItem item = (OrderItem)orderItems.get(0);
        assert (item != null);
        this.cartService.removeItemFromOrder(order, item);
        order = this.cartService.findOrderById(this.orderId);
        List items = order.getOrderItems();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"checkOrderItemsLegacy"}, dependsOnGroups={"removeItemFromOrderLegacy"})
    @Transactional
    public void checkOrderItems() throws PricingException {
        Order order = this.cartService.findOrderById(this.orderId);
        assert (order.getOrderItems().size() == 2);
        BundleOrderItem bundleOrderItem = (BundleOrderItem)this.orderItemService.readOrderItemById(this.bundleOrderItemId);
        assert (bundleOrderItem == null);
    }

    @Test(groups={"addPaymentToOrderLegacy"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class, dependsOnGroups={"checkOrderItemsLegacy"})
    @Rollback(value=false)
    @Transactional
    public void addPaymentToOrder(PaymentInfo paymentInfo) {
        Order order = this.cartService.findOrderById(this.orderId);
        this.cartService.addPaymentToOrder(order, paymentInfo, null);
        order = this.cartService.findOrderById(this.orderId);
        PaymentInfo payment = (PaymentInfo)order.getPaymentInfos().get(order.getPaymentInfos().indexOf(paymentInfo));
        assert (payment != null);
        assert (payment.getOrder() != null);
        assert (payment.getOrder().equals(order));
    }

    @Test(groups={"addFulfillmentGroupToOrderFirstLegacy"}, dataProvider="basicFulfillmentGroupLegacy", dataProviderClass=FulfillmentGroupDataProvider.class, dependsOnGroups={"addPaymentToOrderLegacy"})
    @Rollback(value=false)
    @Transactional
    public void addFulfillmentGroupToOrderFirst(FulfillmentGroup fulfillmentGroup) throws PricingException {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Address address = ((CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order order = this.cartService.findOrderById(this.orderId);
        fulfillmentGroup.setOrder(order);
        fulfillmentGroup.setAddress(address);
        FulfillmentGroup fg = this.cartService.addFulfillmentGroupToOrder(order, fulfillmentGroup);
        assert (fg != null);
        assert (fg.getId() != null);
        assert (fg.getAddress().equals(fulfillmentGroup.getAddress()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
        this.fulfillmentGroupId = fg.getId();
    }

    @Test(groups={"removeFulfillmentGroupFromOrderLegacy"}, dependsOnGroups={"addFulfillmentGroupToOrderFirstLegacy"})
    @Transactional
    public void removeFulfillmentGroupFromOrder() throws PricingException {
        Order order = this.cartService.findOrderById(this.orderId);
        List fgItems = order.getFulfillmentGroups();
        assert (fgItems.size() > 0);
        int startingSize = fgItems.size();
        FulfillmentGroup item = (FulfillmentGroup)fgItems.get(0);
        assert (item != null);
        this.cartService.removeFulfillmentGroupFromOrder(order, item);
        order = this.cartService.findOrderById(this.orderId);
        List items = order.getFulfillmentGroups();
        assert (items != null);
        assert (items.size() == startingSize - 1);
    }

    @Test(groups={"findFulFillmentGroupForOrderFirstLegacy"}, dependsOnGroups={"addFulfillmentGroupToOrderFirstLegacy"})
    @Transactional
    public void findFillmentGroupForOrderFirst() {
        Order order = this.cartService.findOrderById(this.orderId);
        FulfillmentGroup fg = (FulfillmentGroup)order.getFulfillmentGroups().get(0);
        assert (fg != null);
        assert (fg.getId() != null);
        FulfillmentGroup fulfillmentGroup = (FulfillmentGroup)this.em.find(FulfillmentGroupImpl.class, (Object)this.fulfillmentGroupId);
        assert (fg.getAddress().getId().equals(fulfillmentGroup.getAddress().getId()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
    }

    @Test(groups={"addItemToFulfillmentGroupSecondLegacy"}, dependsOnGroups={"addFulfillmentGroupToOrderFirstLegacy"})
    @Transactional
    public void addItemToFulfillmentgroupSecond() {
        String userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(userName);
        Address address = ((CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        FulfillmentGroupImpl newFg = new FulfillmentGroupImpl();
        newFg.setAddress(address);
        newFg.setMethod("standard");
        newFg.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        try {
            newFg = this.cartService.addItemToFulfillmentGroup((OrderItem)orderItems.get(0), (FulfillmentGroup)newFg, 1);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        order = this.cartService.findOrderById(this.orderId);
        FulfillmentGroup newNewFg = (FulfillmentGroup)order.getFulfillmentGroups().get(order.getFulfillmentGroups().indexOf(newFg));
        assert (newNewFg.getFulfillmentGroupItems().size() == 1);
        assert (((FulfillmentGroupItem)newNewFg.getFulfillmentGroupItems().get(0)).getOrderItem().equals(orderItems.get(0)));
    }

    @Test(groups={"findDefaultFulFillmentGroupForOrderLegacy"}, dependsOnGroups={"findCurrentCartForCustomerLegacy", "addFulfillmentGroupToOrderFirstLegacy"})
    @Transactional
    public void findDefaultFillmentGroupForOrder() {
        Order order = this.cartService.findOrderById(this.orderId);
        FulfillmentGroup fg = this.cartService.findDefaultFulfillmentGroupForOrder(order);
        assert (fg != null);
        assert (fg.getId() != null);
        FulfillmentGroup fulfillmentGroup = (FulfillmentGroup)this.em.find(FulfillmentGroupImpl.class, (Object)this.fulfillmentGroupId);
        assert (fg.getAddress().getId().equals(fulfillmentGroup.getAddress().getId()));
        assert (fg.getOrder().equals(order));
        assert (fg.getMethod().equals(fulfillmentGroup.getMethod()));
        assert (fg.getReferenceNumber().equals(fulfillmentGroup.getReferenceNumber()));
    }

    @Test(groups={"removeItemFromOrderAfterDefaultFulfillmentGroupLegacy"}, dependsOnGroups={"addFulfillmentGroupToOrderFirstLegacy"})
    @Transactional
    public void removeItemFromOrderAfterFulfillmentGroups() {
        Order order = this.cartService.findOrderById(this.orderId);
        List orderItems = order.getOrderItems();
        assert (orderItems.size() > 0);
        OrderItem item = (OrderItem)orderItems.get(0);
        assert (item != null);
        try {
            this.cartService.removeItemFromOrder(order, item);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        FulfillmentGroup fg = this.cartService.findDefaultFulfillmentGroupForOrder(order);
        for (FulfillmentGroupItem fulfillmentGroupItem : fg.getFulfillmentGroupItems()) {
            assert (!fulfillmentGroupItem.getOrderItem().equals(item));
        }
    }

    @Test(groups={"getOrdersForCustomerLegacy"}, dependsOnGroups={"readCustomer", "findCurrentCartForCustomerLegacy"})
    @Transactional
    public void getOrdersForCustomer() {
        String username = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(username);
        List orders = this.cartService.findOrdersForCustomer(customer);
        assert (orders != null);
        assert (orders.size() > 0);
    }

    @Test(groups={"findCartForAnonymousCustomerLegacy"}, dependsOnGroups={"getOrdersForCustomerLegacy"})
    public void findCartForAnonymousCustomer() {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.findCartForCustomer(customer);
        assert (order == null);
        order = this.cartService.createNewCartForCustomer(customer);
        Long orderId = order.getId();
        Order newOrder = this.cartService.findOrderById(orderId);
        assert (newOrder != null);
        assert (newOrder.getCustomer() != null);
    }

    @Test(groups={"findOrderByOrderNumberLegacy"}, dependsOnGroups={"findCartForAnonymousCustomerLegacy"})
    @Transactional
    public void findOrderByOrderNumber() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setOrderNumber("3456");
        order = this.cartService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.cartService.findOrderByOrderNumber("3456");
        assert (newOrder.getId().equals(orderId));
        Order nullOrder = this.cartService.findOrderByOrderNumber(null);
        assert (nullOrder == null);
        nullOrder = this.cartService.findOrderByOrderNumber("");
        assert (nullOrder == null);
    }

    @Test(groups={"findNamedOrderForCustomerLegacy"}, dependsOnGroups={"findOrderByOrderNumberLegacy"})
    @Transactional
    public void findNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.NAMED);
        order.setName("COOL ORDER");
        order = this.cartService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order newOrder = this.cartService.findNamedOrderForCustomer("COOL ORDER", customer);
        assert (newOrder.getId().equals(orderId));
    }

    @Test(groups={"testReadOrdersForCustomerLegacy"}, dependsOnGroups={"findNamedOrderForCustomerLegacy"})
    @Transactional
    public void testReadOrdersForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.cartService.save(order, Boolean.valueOf(false));
        List newOrders = this.cartService.findOrdersForCustomer(customer, OrderStatus.IN_PROCESS);
        boolean containsOrder = false;
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
        containsOrder = false;
        newOrders = this.cartService.findOrdersForCustomer(customer, null);
        if (newOrders.contains(order)) {
            containsOrder = true;
        }
        assert (containsOrder);
    }

    @Test(groups={"testOrderPropertiesLegacy"}, dependsOnGroups={"testReadOrdersForCustomerLegacy"})
    public void testOrderProperties() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        assert (order.getSubTotal() == null);
        assert (order.getTotal() == null);
        assert (order.getRemainingTotal() == null);
        Calendar testCalendar = Calendar.getInstance();
        order.setSubmitDate(testCalendar.getTime());
        assert (order.getSubmitDate().equals(testCalendar.getTime()));
    }

    @Test(groups={"testNamedOrderForCustomerLegacy"}, dependsOnGroups={"testOrderPropertiesLegacy"})
    public void testNamedOrderForCustomer() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        customer = this.customerService.saveCustomer(customer);
        Order order = this.cartService.createNamedOrderForCustomer("Birthday Order", customer);
        Long orderId = order.getId();
        assert (order != null);
        assert (order.getName().equals("Birthday Order"));
        assert (order.getCustomer().equals(customer));
        this.cartService.removeNamedOrderForCustomer("Birthday Order", customer);
        assert (this.cartService.findOrderById(orderId) == null);
    }

    @Test(groups={"testAddSkuToOrderLegacy"})
    @Transactional
    public void testAddSkuToOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.customerService.createCustomerFromId(null));
        CategoryImpl category = new CategoryImpl();
        category.setName("Pants");
        category = this.catalogService.saveCategory((Category)category);
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        SkuImpl newDefaultSku = new SkuImpl();
        newDefaultSku.setName("Leather Pants");
        newDefaultSku.setRetailPrice(new Money(44.99));
        newDefaultSku.setActiveStartDate(activeStartCal.getTime());
        newDefaultSku.setDiscountable(Boolean.valueOf(true));
        newDefaultSku = this.catalogService.saveSku((Sku)newDefaultSku);
        ProductImpl newProduct = new ProductImpl();
        newProduct.setDefaultCategory((Category)category);
        newProduct.setDefaultSku((Sku)newDefaultSku);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Order order = this.cartService.createNamedOrderForCustomer("Pants Order", customer);
        OrderItem orderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem quantityNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), category.getId(), null);
        OrderItem skuNullOrderItem = this.cartService.addSkuToOrder(order.getId(), null, null, category.getId(), Integer.valueOf(2));
        OrderItem orderNullOrderItem = this.cartService.addSkuToOrder(null, newDefaultSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem productNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), null, category.getId(), Integer.valueOf(2));
        OrderItem categoryNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), null, Integer.valueOf(2));
        assert (orderItem != null);
        assert (skuNullOrderItem == null);
        assert (quantityNullOrderItem == null);
        assert (orderNullOrderItem == null);
        assert (productNullOrderItem != null);
        assert (categoryNullOrderItem != null);
    }

    @Test(groups={"testOrderPaymentInfosLegacy"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class)
    @Transactional
    public void testOrderPaymentInfos(PaymentInfo info) throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        Order order = this.cartService.createNewCartForCustomer(customer);
        this.cartService.addPaymentToOrder(order, info);
        boolean foundInfo = false;
        assert (order.getPaymentInfos() != null);
        for (PaymentInfo testInfo : order.getPaymentInfos()) {
            if (!testInfo.equals(info)) continue;
            foundInfo = true;
        }
        assert (foundInfo);
        assert (this.cartService.readPaymentInfosForOrder(order) != null);
    }

    @Test(groups={"testSubmitOrderLegacy"}, dependsOnGroups={"findNamedOrderForCustomerLegacy"})
    public void testSubmitOrder() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.cartService.createNewCartForCustomer(customer);
        order.setStatus(OrderStatus.IN_PROCESS);
        order = this.cartService.save(order, Boolean.valueOf(false));
        Long orderId = order.getId();
        Order confirmedOrder = this.cartService.confirmOrder(order);
        confirmedOrder = this.cartService.findOrderById(confirmedOrder.getId());
        Long confirmedOrderId = confirmedOrder.getId();
        assert (orderId.equals(confirmedOrderId));
        assert (confirmedOrder.getStatus().equals((Object)OrderStatus.SUBMITTED));
    }

    @Test
    public void findCartForNullCustomerId() {
        assert (this.cartService.findCartForCustomer((Customer)new CustomerImpl()) == null);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testCreateNamedOrder() throws PricingException {
        Customer customer = this.customerService.saveCustomer(this.customerService.createCustomerFromId(null));
        Calendar activeStartCal = Calendar.getInstance();
        activeStartCal.add(6, -2);
        CategoryImpl category = new CategoryImpl();
        category.setName("Pants");
        category.setActiveStartDate(activeStartCal.getTime());
        category = this.catalogService.saveCategory((Category)category);
        SkuImpl newDefaultSku = new SkuImpl();
        newDefaultSku.setName("Leather Pants");
        newDefaultSku.setRetailPrice(new Money(44.99));
        newDefaultSku.setActiveStartDate(activeStartCal.getTime());
        newDefaultSku.setDiscountable(Boolean.valueOf(true));
        newDefaultSku = this.catalogService.saveSku((Sku)newDefaultSku);
        ProductImpl newProduct = new ProductImpl();
        newProduct.setDefaultCategory((Category)category);
        newProduct.setDefaultSku((Sku)newDefaultSku);
        newProduct = this.catalogService.saveProduct((Product)newProduct);
        Order order = this.cartService.createNamedOrderForCustomer("Pants Order", customer);
        OrderItem orderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem quantityNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), category.getId(), null);
        OrderItem skuNullOrderItem = this.cartService.addSkuToOrder(order.getId(), null, null, category.getId(), Integer.valueOf(2));
        OrderItem orderNullOrderItem = this.cartService.addSkuToOrder(null, newDefaultSku.getId(), newProduct.getId(), category.getId(), Integer.valueOf(2));
        OrderItem productNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), null, category.getId(), Integer.valueOf(2));
        OrderItem categoryNullOrderItem = this.cartService.addSkuToOrder(order.getId(), newDefaultSku.getId(), newProduct.getId(), null, Integer.valueOf(2));
        assert (orderItem != null);
        assert (skuNullOrderItem == null);
        assert (quantityNullOrderItem == null);
        assert (orderNullOrderItem == null);
        assert (productNullOrderItem != null);
        assert (categoryNullOrderItem != null);
    }

    @Test(groups={"testOrderFulfillmentGroupsLegacy"}, dataProvider="basicShippingRates", dataProviderClass=ShippingRateDataProvider.class)
    @Transactional
    public void testAddFulfillmentGroupToOrder(ShippingRate shippingRate, ShippingRate sr2) throws PricingException, ItemNotFoundException {
        shippingRate = this.shippingRateService.save(shippingRate);
        sr2 = this.shippingRateService.save(sr2);
        Customer customer = this.createCustomerWithAddresses();
        Order order = this.initializeExistingCart(customer);
        CustomerAddress customerAddress = (CustomerAddress)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0);
        FulfillmentGroupRequest fgRequest = new FulfillmentGroupRequest();
        ArrayList<FulfillmentGroupItemRequest> fgiRequests = new ArrayList<FulfillmentGroupItemRequest>();
        for (OrderItem orderItem : order.getOrderItems()) {
            FulfillmentGroupItemRequest fgiRequest = new FulfillmentGroupItemRequest();
            fgiRequest.setOrderItem(orderItem);
            fgiRequest.setQuantity(1);
            fgiRequests.add(fgiRequest);
        }
        fgRequest.setAddress(customerAddress.getAddress());
        fgRequest.setFulfillmentGroupItemRequests(fgiRequests);
        fgRequest.setOrder(this.cartService.findCartForCustomer(customer));
        fgRequest.setMethod("standard");
        fgRequest.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        this.cartService.addFulfillmentGroupToOrder(fgRequest);
        Order resultOrder = this.cartService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 1);
        assert (((FulfillmentGroup)resultOrder.getFulfillmentGroups().get(0)).getFulfillmentGroupItems().size() == 2);
        this.cartService.removeAllFulfillmentGroupsFromOrder(order, false);
        resultOrder = this.cartService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 0);
        FulfillmentGroup defaultFg = this.cartService.createDefaultFulfillmentGroup(order, customerAddress.getAddress());
        defaultFg.setMethod("standard");
        defaultFg.setService(ShippingServiceType.BANDED_SHIPPING.getType());
        assert (defaultFg.isPrimary());
        this.cartService.addFulfillmentGroupToOrder(order, defaultFg);
        resultOrder = this.cartService.findOrderById(order.getId());
        assert (resultOrder.getFulfillmentGroups().size() == 1);
    }
}

