/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.legacy;

import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.legacy.LegacyOrderBaseTest;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class LegacyCartTest
extends LegacyOrderBaseTest {
    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testMoveAllItemsToCartFromNamedOrder() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.cartService.createNewCartForCustomer(namedOrder.getCustomer());
        cart = this.cartService.moveAllItemsToCartFromNamedOrder(namedOrder);
        assert (((Object)namedOrderItems).equals(cart.getOrderItems()));
        assert (namedOrder.getOrderItems().size() == 0);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testAddAllItemsToCartFromNamedOrder() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.cartService.createNewCartForCustomer(namedOrder.getCustomer());
        this.cartService.setMoveNamedOrderItems(false);
        cart = this.cartService.addAllItemsToCartFromNamedOrder(namedOrder);
        assert (((Object)namedOrderItems).equals(cart.getOrderItems()));
        this.cartService.setMoveNamedOrderItems(true);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testAddAllItemsToCartFromNamedOrderWithoutExistingCart() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        this.cartService.setMoveNamedOrderItems(false);
        Order cart = this.cartService.addAllItemsToCartFromNamedOrder(namedOrder);
        assert (((Object)namedOrderItems).equals(cart.getOrderItems()));
        this.cartService.setMoveNamedOrderItems(true);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testAddItemToCartFromNamedOrder() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.cartService.createNewCartForCustomer(namedOrder.getCustomer());
        this.cartService.setMoveNamedOrderItems(false);
        OrderItem movedItem = this.cartService.moveItemToCartFromNamedOrder(namedOrder, (OrderItem)namedOrderItems.get(0));
        this.cartService.setMoveNamedOrderItems(true);
        assert (movedItem != null);
        assert (cart.getOrderItems().size() == 1);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testMoveItemToCartFromNamedOrder() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        Order cart = this.cartService.createNewCartForCustomer(namedOrder.getCustomer());
        OrderItem movedItem = this.cartService.moveItemToCartFromNamedOrder(namedOrder, (OrderItem)namedOrderItems.get(0));
        List customerNamedOrders = this.cartService.findOrdersForCustomer(namedOrder.getCustomer(), OrderStatus.NAMED);
        assert (customerNamedOrders.size() == 0);
        assert (movedItem != null);
        assert (cart.getOrderItems().size() == 1);
        assert (namedOrder.getOrderItems().size() == 0);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testMoveItemToCartFromNamedOrderWithoutExistingCart() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        OrderItem movedItem = this.cartService.moveItemToCartFromNamedOrder(namedOrder, (OrderItem)namedOrderItems.get(0));
        List customerNamedOrders = this.cartService.findOrdersForCustomer(namedOrder.getCustomer(), OrderStatus.NAMED);
        Order cart = this.cartService.findCartForCustomer(namedOrder.getCustomer());
        assert (customerNamedOrders.size() == 0);
        assert (movedItem != null);
        assert (cart.getOrderItems().size() == 1);
        assert (namedOrder.getOrderItems().size() == 0);
    }

    @Test(groups={"testCartAndNamedOrderLegacy"})
    @Transactional
    public void testMoveItemToCartFromNamedOrderByIds() throws PricingException {
        Order namedOrder = this.setUpNamedOrder();
        ArrayList namedOrderItems = new ArrayList();
        namedOrderItems.addAll(namedOrder.getOrderItems());
        OrderItem movedItem = this.cartService.moveItemToCartFromNamedOrder(namedOrder.getCustomer().getId(), namedOrder.getName(), ((OrderItem)namedOrderItems.get(0)).getId(), Integer.valueOf(((OrderItem)namedOrderItems.get(0)).getQuantity()));
        List customerNamedOrders = this.cartService.findOrdersForCustomer(namedOrder.getCustomer(), OrderStatus.NAMED);
        Order cart = this.cartService.findCartForCustomer(namedOrder.getCustomer());
        assert (customerNamedOrders.size() == 0);
        assert (movedItem != null);
        assert (cart.getOrderItems().size() == 1);
        assert (namedOrder.getOrderItems().size() == 0);
    }

    @Transactional
    @Test(groups={"testMergeCartLegacy"})
    public void testMergeToEmptyCart() throws PricingException {
        Order anonymousCart = this.setUpAnonymousCartWithInactiveSku();
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        MergeCartResponse response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 2);
        assert (response.getOrder().getOrderItems().size() == 2);
        assert (!response.isMerged());
        assert (response.getRemovedItems().size() == 2);
    }

    @Transactional
    @Test(groups={"testMergeCartLegacy"})
    public void testMergeToExistingCart() throws PricingException {
        Order anonymousCart = this.setUpAnonymousCartWithInactiveSku();
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCartWithInactiveSkuAndInactiveBundle(customer);
        MergeCartResponse response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 2);
        assert (response.getOrder().getOrderItems().size() == 4);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 4);
    }

    @Transactional
    @Test(groups={"testMergeCartLegacy"})
    public void testMergeToExistingCartWithGiftWrapOrderItems() throws PricingException {
        Order anonymousCart = this.setUpAnonymousCartWithGiftWrap();
        Customer customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        MergeCartResponse response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 3);
        assert (response.getOrder().getOrderItems().size() == 5);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 0);
        anonymousCart = this.setUpAnonymousCartWithInactiveGiftWrap();
        customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 1);
        assert (response.getOrder().getOrderItems().size() == 3);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 2);
        anonymousCart = this.setUpAnonymousCartWithInactiveBundleGiftWrap();
        customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 0);
        assert (response.getOrder().getOrderItems().size() == 2);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 1);
        anonymousCart = this.setUpAnonymousCartWithBundleGiftWrap();
        customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 1);
        assert (response.getOrder().getOrderItems().size() == 3);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 0);
        anonymousCart = this.setUpAnonymousCartWithBundleGiftWrapReferringToRootItems();
        customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 3);
        assert (response.getOrder().getOrderItems().size() == 5);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 0);
        anonymousCart = this.setUpAnonymousCartWithBundleGiftWrapReferringItemsInAnotherBundle();
        customer = this.customerService.saveCustomer(this.createNamedCustomer());
        this.initializeExistingCart(customer);
        response = this.cartService.mergeCart(customer, anonymousCart);
        assert (response.getAddedItems().size() == 1);
        assert (response.getOrder().getOrderItems().size() == 3);
        assert (response.isMerged());
        assert (response.getRemovedItems().size() == 1);
    }
}

