/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.PaymentInfoDataProvider;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.profile.core.dao.CustomerAddressDao;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class PaymentInfoServiceTest
extends BaseTest {
    String userName = new String();
    private PaymentInfo paymentInfo;
    @Resource
    private PaymentInfoService paymentInfoService;
    @Resource(name="blOrderService")
    private OrderService orderService;
    @Resource
    private CustomerAddressDao customerAddressDao;
    @Resource
    private CustomerService customerService;

    @Test(groups={"createPaymentInfo"}, dataProvider="basicPaymentInfo", dataProviderClass=PaymentInfoDataProvider.class, dependsOnGroups={"readCustomer", "createOrder"})
    @Rollback(value=false)
    @Transactional
    public void createPaymentInfo(PaymentInfo paymentInfo) {
        this.userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(this.userName);
        List addresses = this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customer.getId());
        Address address = null;
        if (!addresses.isEmpty()) {
            address = ((CustomerAddress)addresses.get(0)).getAddress();
        }
        Order salesOrder = this.orderService.createNewCartForCustomer(customer);
        paymentInfo.setAddress(address);
        paymentInfo.setOrder(salesOrder);
        paymentInfo.setType(PaymentInfoType.CREDIT_CARD);
        assert (paymentInfo.getId() == null);
        paymentInfo = this.paymentInfoService.save(paymentInfo);
        assert (paymentInfo.getId() != null);
        this.paymentInfo = paymentInfo;
    }

    @Test(groups={"readPaymentInfoById"}, dependsOnGroups={"createPaymentInfo"})
    public void readPaymentInfoById() {
        PaymentInfo sop = this.paymentInfoService.readPaymentInfoById(this.paymentInfo.getId());
        assert (sop != null);
        assert (sop.getId().equals(this.paymentInfo.getId()));
    }

    @Test(groups={"readPaymentInfosByOrder"}, dependsOnGroups={"createPaymentInfo"})
    @Transactional
    public void readPaymentInfoByOrder() {
        List payments = this.paymentInfoService.readPaymentInfosForOrder(this.paymentInfo.getOrder());
        assert (payments != null);
        assert (payments.size() > 0);
    }

    @Test(groups={"testCreatePaymentInfo"}, dependsOnGroups={"createPaymentInfo"})
    @Transactional
    public void createTestPaymentInfo() {
        this.userName = "customer1";
        PaymentInfo paymentInfo = this.paymentInfoService.create();
        Customer customer = this.customerService.readCustomerByUsername(this.userName);
        List addresses = this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customer.getId());
        Address address = null;
        if (!addresses.isEmpty()) {
            address = ((CustomerAddress)addresses.get(0)).getAddress();
        }
        Order salesOrder = this.orderService.findCartForCustomer(customer);
        paymentInfo.setAddress(address);
        paymentInfo.setOrder(salesOrder);
        paymentInfo.setType(PaymentInfoType.CREDIT_CARD);
        assert (paymentInfo != null);
        paymentInfo = this.paymentInfoService.save(paymentInfo);
        assert (paymentInfo.getId() != null);
        Long paymentInfoId = paymentInfo.getId();
        this.paymentInfoService.delete(paymentInfo);
        paymentInfo = this.paymentInfoService.readPaymentInfoById(paymentInfoId);
        assert (paymentInfo == null);
    }
}

