/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.OrderDataProvider;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.test.BaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class OrderDaoTest
extends BaseTest {
    String userName = new String();
    Long orderId;
    @Resource
    private OrderDao orderDao;
    @Resource
    private CustomerService customerService;

    @Test(groups={"createOrder"}, dataProvider="basicOrder", dataProviderClass=OrderDataProvider.class, dependsOnGroups={"readCustomer", "createPhone"})
    @Rollback(value=false)
    @Transactional
    public void createOrder(Order order) {
        this.userName = "customer1";
        Customer customer = this.customerService.readCustomerByUsername(this.userName);
        assert (order.getId() == null);
        order.setCustomer(customer);
        order = this.orderDao.save(order);
        assert (order.getId() != null);
        this.orderId = order.getId();
    }

    @Test(groups={"readOrder"}, dependsOnGroups={"createOrder"})
    public void readOrderById() {
        Order result = this.orderDao.readOrderById(this.orderId);
        assert (result != null);
    }

    @Test(groups={"readOrdersForCustomer"}, dependsOnGroups={"readCustomer", "createOrder"})
    @Transactional
    public void readOrdersForCustomer() {
        this.userName = "customer1";
        Customer user = this.customerService.readCustomerByUsername(this.userName);
        List orders = this.orderDao.readOrdersForCustomer(user.getId());
        assert (orders.size() > 0);
    }
}

