/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.common.workflow;

import java.util.List;
import org.broadleafcommerce.core.pricing.service.workflow.TotalActivity;
import org.broadleafcommerce.core.workflow.Activity;
import org.broadleafcommerce.core.workflow.ModuleActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.SequenceProcessor;
import org.broadleafcommerce.core.workflow.state.test.TestExampleModuleActivity;
import org.broadleafcommerce.core.workflow.state.test.TestPassThroughActivity;
import org.broadleafcommerce.core.workflow.state.test.TestRollbackActivity;
import org.broadleafcommerce.test.BaseTest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class WorkflowTest
extends BaseTest {
    protected List<Activity<ProcessContext>> activities;

    @BeforeTest
    public void setup() {
        this.activities = ((SequenceProcessor)WorkflowTest.getContext().getBean("blCheckoutWorkflow")).getActivities();
    }

    @Test
    public void testMergedOrderedActivities() {
        Assert.assertEquals(this.activities.get(0).getClass(), TestPassThroughActivity.class);
        Assert.assertEquals((int)this.activities.get(0).getOrder(), (int)100);
        Assert.assertEquals(this.activities.get(4).getClass(), TestPassThroughActivity.class);
        Assert.assertEquals((int)this.activities.get(4).getOrder(), (int)3000);
    }

    @Test
    public void testFrameworkOrderingChanged() {
        TotalActivity totalActivity = (TotalActivity)WorkflowTest.getContext().getBean("blTotalActivity");
        Assert.assertEquals((int)totalActivity.getOrder(), (int)8080);
    }

    @Test
    public void testDetectedModuleActivity() {
        List moduleActivities = ((SequenceProcessor)WorkflowTest.getContext().getBean("blCheckoutWorkflow")).getModuleActivities();
        Assert.assertEquals((int)moduleActivities.size(), (int)1);
        Assert.assertEquals((String)((ModuleActivity)moduleActivities.get(0)).getModuleName(), (String)"integration");
    }

    @Test
    public void testNonExplicitOrdering() {
        Assert.assertEquals(this.activities.get(this.activities.size() - 1).getClass(), TestExampleModuleActivity.class);
        Assert.assertEquals((int)this.activities.get(this.activities.size() - 1).getOrder(), (int)Integer.MAX_VALUE);
    }

    @Test
    public void testSameOrderingConfiguredActivity() {
        Assert.assertEquals(this.activities.get(7).getClass(), TestRollbackActivity.class);
    }

    @Test
    public void testInBetweenActivity() {
        Assert.assertEquals(this.activities.get(4).getClass(), TestPassThroughActivity.class);
    }

    static {
        WorkflowTest.getModuleContexts().add("bl-applicationContext-test-module.xml");
    }
}

