/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import javax.annotation.Resource;
import org.broadleafcommerce.core.order.FulfillmentGroupDataProvider;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupDao;
import org.broadleafcommerce.core.order.dao.OrderDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.profile.core.dao.CustomerAddressDao;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.test.CommonSetupBaseTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class FulfillmentGroupDaoTest
extends CommonSetupBaseTest {
    private Long defaultFulfillmentGroupOrderId;
    private Long defaultFulfillmentGroupId;
    private Long fulfillmentGroupId;
    @Resource
    private FulfillmentGroupDao fulfillmentGroupDao;
    @Resource
    private FulfillmentGroupService fulfillmentGroupService;
    @Resource
    private CustomerAddressDao customerAddressDao;
    @Resource
    private OrderDao orderDao;

    @Test(groups={"createDefaultFulfillmentGroup"}, dataProvider="basicFulfillmentGroup", dataProviderClass=FulfillmentGroupDataProvider.class)
    @Transactional
    @Rollback(value=false)
    public void createDefaultFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        Customer customer = this.createCustomerWithBasicOrderAndAddresses();
        Address address = ((CustomerAddress)this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order salesOrder = (Order)this.orderDao.readOrdersForCustomer(customer.getId()).get(0);
        FulfillmentGroup newFG = this.fulfillmentGroupDao.createDefault();
        newFG.setAddress(address);
        newFG.setRetailShippingPrice(fulfillmentGroup.getRetailShippingPrice());
        newFG.setMethod(fulfillmentGroup.getMethod());
        newFG.setService(fulfillmentGroup.getService());
        newFG.setOrder(salesOrder);
        newFG.setReferenceNumber(fulfillmentGroup.getReferenceNumber());
        assert (newFG.getId() == null);
        fulfillmentGroup = this.fulfillmentGroupService.save(newFG);
        assert (fulfillmentGroup.getId() != null);
        this.defaultFulfillmentGroupOrderId = salesOrder.getId();
        this.defaultFulfillmentGroupId = fulfillmentGroup.getId();
    }

    @Test(groups={"readDefaultFulfillmentGroupForOrder"}, dependsOnGroups={"createDefaultFulfillmentGroup"})
    @Transactional
    public void readDefaultFulfillmentGroupForOrder() {
        Order order = this.orderDao.readOrderById(this.defaultFulfillmentGroupOrderId);
        assert (order != null);
        assert (order.getId() == this.defaultFulfillmentGroupOrderId);
        FulfillmentGroup fg = this.fulfillmentGroupDao.readDefaultFulfillmentGroupForOrder(order);
        assert (fg.getId() != null);
        assert (fg.getId().equals(this.defaultFulfillmentGroupId));
    }

    @Test(groups={"readDefaultFulfillmentGroupForId"}, dependsOnGroups={"createDefaultFulfillmentGroup"})
    @Transactional
    public void readDefaultFulfillmentGroupForId() {
        FulfillmentGroup fg = this.fulfillmentGroupDao.readFulfillmentGroupById(this.defaultFulfillmentGroupId);
        assert (fg != null);
        assert (fg.getId() != null);
        assert (fg.getId().equals(this.defaultFulfillmentGroupId));
    }

    @Test(groups={"createFulfillmentGroup"}, dataProvider="basicFulfillmentGroup", dataProviderClass=FulfillmentGroupDataProvider.class)
    @Transactional
    @Rollback(value=false)
    public void createFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        Customer customer = this.createCustomerWithBasicOrderAndAddresses();
        Address address = ((CustomerAddress)this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customer.getId()).get(0)).getAddress();
        Order salesOrder = (Order)this.orderDao.readOrdersForCustomer(customer.getId()).get(0);
        FulfillmentGroup newFG = this.fulfillmentGroupDao.create();
        newFG.setAddress(address);
        newFG.setRetailShippingPrice(fulfillmentGroup.getRetailShippingPrice());
        newFG.setMethod(fulfillmentGroup.getMethod());
        newFG.setService(fulfillmentGroup.getService());
        newFG.setReferenceNumber(fulfillmentGroup.getReferenceNumber());
        newFG.setOrder(salesOrder);
        assert (newFG.getId() == null);
        fulfillmentGroup = this.fulfillmentGroupService.save(newFG);
        assert (fulfillmentGroup.getId() != null);
        this.fulfillmentGroupId = fulfillmentGroup.getId();
    }

    @Test(groups={"readFulfillmentGroupsForId"}, dependsOnGroups={"createFulfillmentGroup"})
    @Transactional
    public void readFulfillmentGroupsForId() {
        FulfillmentGroup fg = this.fulfillmentGroupDao.readFulfillmentGroupById(this.fulfillmentGroupId);
        assert (fg != null);
        assert (fg.getId() != null);
    }
}

