/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItemImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItemImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.domain.OrderMultishipOptionImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.FixedPriceFulfillmentOptionImpl;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.core.order.service.type.OrderItemType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.test.CommonSetupBaseTest;
import org.springframework.transaction.annotation.Transactional;
import org.testng.annotations.Test;

public class OfferServiceTest
extends CommonSetupBaseTest {
    @Resource
    protected OfferService offerService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource
    protected CustomerService customerService;
    @Resource
    protected CatalogService catalogService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    private Order createTestOrderWithOfferAndGiftWrap() throws PricingException {
        Customer customer = this.customerService.createCustomerFromId(null);
        Order order = this.orderService.createNewCartForCustomer(customer);
        this.customerService.saveCustomer(order.getCustomer());
        this.createCountry();
        this.createState();
        AddressImpl address = new AddressImpl();
        address.setAddressLine1("123 Test Rd");
        address.setCity("Dallas");
        address.setFirstName("Jeff");
        address.setLastName("Fischer");
        address.setPostalCode("75240");
        address.setPrimaryPhone("972-978-9067");
        address.setState(this.stateService.findStateByAbbreviation("KY"));
        address.setCountry(this.countryService.findCountryByAbbreviation("US"));
        FulfillmentGroupImpl group = new FulfillmentGroupImpl();
        group.setAddress((Address)address);
        group.setIsShippingPriceTaxable(Boolean.valueOf(true));
        ArrayList<FulfillmentGroupImpl> groups = new ArrayList<FulfillmentGroupImpl>();
        FixedPriceFulfillmentOptionImpl option = new FixedPriceFulfillmentOptionImpl();
        option.setPrice(new Money("8.50"));
        option.setFulfillmentType(FulfillmentType.PHYSICAL_SHIP);
        group.setFulfillmentOption((FulfillmentOption)option);
        group.setFulfillmentOption((FulfillmentOption)option);
        group.setOrder(order);
        groups.add(group);
        order.setFulfillmentGroups(groups);
        Money total = new Money(5.0);
        group.setRetailShippingPrice(total);
        group.setShippingPrice(total);
        DiscreteOrderItemImpl item1 = new DiscreteOrderItemImpl();
        SkuImpl sku = new SkuImpl();
        sku.setName("Test Sku");
        sku.setRetailPrice(new Money(10.0));
        sku.setDiscountable(Boolean.valueOf(true));
        sku = this.catalogService.saveSku((Sku)sku);
        item1.setSku((Sku)sku);
        item1.setQuantity(2);
        item1.setOrder(order);
        item1.setOrderItemType(OrderItemType.DISCRETE);
        item1 = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item1);
        order.addOrderItem((OrderItem)item1);
        FulfillmentGroupItemImpl fgItem = new FulfillmentGroupItemImpl();
        fgItem.setFulfillmentGroup((FulfillmentGroup)group);
        fgItem.setOrderItem((OrderItem)item1);
        fgItem.setQuantity(2);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem);
        DiscreteOrderItemImpl item = new DiscreteOrderItemImpl();
        SkuImpl sku2 = new SkuImpl();
        sku2.setName("Test Product 2");
        sku2.setRetailPrice(new Money(20.0));
        sku2.setDiscountable(Boolean.valueOf(true));
        sku2 = this.catalogService.saveSku((Sku)sku2);
        item.setSku((Sku)sku2);
        item.setQuantity(1);
        item.setOrder(order);
        item.setOrderItemType(OrderItemType.DISCRETE);
        item = (DiscreteOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        order.addOrderItem((OrderItem)item);
        FulfillmentGroupItemImpl fgItem2 = new FulfillmentGroupItemImpl();
        fgItem2.setFulfillmentGroup((FulfillmentGroup)group);
        fgItem2.setOrderItem((OrderItem)item);
        fgItem2.setQuantity(1);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem2);
        item = new GiftWrapOrderItemImpl();
        sku2 = new SkuImpl();
        sku2.setName("Test GiftWrap");
        sku2.setRetailPrice(new Money(1.0));
        sku2.setDiscountable(Boolean.valueOf(true));
        sku2 = this.catalogService.saveSku((Sku)sku2);
        item.setSku((Sku)sku2);
        item.setQuantity(1);
        item.setOrder(order);
        item.getWrappedItems().add(item1);
        item.setOrderItemType(OrderItemType.GIFTWRAP);
        item = (GiftWrapOrderItem)this.orderItemService.saveOrderItem((OrderItem)item);
        order.addOrderItem((OrderItem)item);
        fgItem2 = new FulfillmentGroupItemImpl();
        fgItem2.setFulfillmentGroup((FulfillmentGroup)group);
        fgItem2.setOrderItem((OrderItem)item);
        fgItem2.setQuantity(1);
        group.addFulfillmentGroupItem((FulfillmentGroupItem)fgItem2);
        return order;
    }

    @Test(groups={"testOffersWithGiftWrap"}, dependsOnGroups={"testShippingInsert"})
    @Transactional
    public void testOrderItemOfferWithGiftWrap() throws PricingException {
        Order order = this.createTestOrderWithOfferAndGiftWrap();
        OfferDataItemProvider dataProvider = new OfferDataItemProvider();
        List offers = dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"Test Sku\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.sku.name))", "([MVEL.eval(\"toUpperCase()\",\"Test Sku\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.sku.name))");
        for (Offer offer : offers) {
            offer.setName("testOffer");
            this.offerService.save(offer);
        }
        order = this.orderService.save(order, Boolean.valueOf(false));
        HashSet<OrderMultishipOptionImpl> options = new HashSet<OrderMultishipOptionImpl>();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            Address address = fulfillmentGroup.getAddress();
            for (FulfillmentGroupItem fgItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                for (int j = 0; j < fgItem.getQuantity(); ++j) {
                    OrderMultishipOptionImpl option = new OrderMultishipOptionImpl();
                    option.setOrder(order);
                    option.setAddress(address);
                    option.setOrderItem(fgItem.getOrderItem());
                    option.setFulfillmentOption(fulfillmentGroup.getFulfillmentOption());
                    options.add(option);
                }
            }
        }
        for (OrderMultishipOption orderMultishipOption : options) {
            this.orderMultishipOptionService.save(orderMultishipOption);
        }
        order = this.fulfillmentGroupService.matchFulfillmentGroupsToMultishipOptions(order, true);
        assert (order.getOrderItems().size() == 3);
        assert (order.getTotalTax().equals((Object)new Money("2.00")));
        assert (order.getTotalShipping().equals((Object)new Money("8.50")));
        assert (order.getSubTotal().equals((Object)new Money("40.00")));
        assert (order.getTotal().equals((Object)new Money("50.50")));
        boolean foundGiftItemAndCorrectQuantity = false;
        for (OrderItem orderItem : order.getOrderItems()) {
            if (!(orderItem instanceof GiftWrapOrderItem) || ((GiftWrapOrderItem)orderItem).getWrappedItems().size() != 1) continue;
            foundGiftItemAndCorrectQuantity = true;
            break;
        }
        assert (foundGiftItemAndCorrectQuantity);
    }
}

